/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.io.IOException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implementation bypassing the server's hostname validation, allowing the
 * client to connect to any server that passes the trust-store check.
 *
 * @deprecated the {@link X509HostnameVerifier} is deprecated, should be
 *             replaced by {@link HostnameVerifier}
 */
@Deprecated
class AllowAllHostnameVerifier
        implements org.apache.http.conn.ssl.X509HostnameVerifier {

    private static Logger logger =
            LoggerFactory.getLogger(AllowAllHostnameVerifier.class);

    @Override
    public boolean verify(String hostname, SSLSession session) {
        warn(hostname);
        return true;
    }

    @Override
    public void verify(String host, SSLSocket ssl) throws IOException {
        warn(host);
    }

    @Override
    public void verify(String host, X509Certificate cert) throws SSLException {
        warn(host);
    }

    @Override
    public void verify(String host, String[] cns, String[] subjectAlts)
            throws SSLException {
        warn(host);
    }

    private static void warn(String hostname) {
        logger.warn("Cannot validate the identity of {} due to the hostname-"
                  + "verification being disabled. You are susceptible to "
                  + "man-in-the-middle attacks!", hostname);
    }

}
