/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;

/**
 * Base class for {@link HttpRequest} decorators. Saves boilerplate if you need
 * to alter the behavior of just a few methods.
 */
public abstract class DecoratorHttpRequest implements HttpRequest {

    protected final HttpRequest decorated;

    public DecoratorHttpRequest(HttpRequest decorated) {
        this.decorated = Objects.requireNonNull(decorated);
    }

    @Override
    public String getUrl() {
        return decorated.getUrl();
    }

    @Override
    public void setUrl(String url) {
        decorated.setUrl(url);
    }

    @Override
    public HttpMethod getMethod() {
        return decorated.getMethod();
    }

    @Override
    public void setMethod(HttpMethod method) {
        decorated.setMethod(method);
    }

    @Override
    public byte[] getBody() {
        return decorated.getBody();
    }

    @Override
    public void setBody(byte[] body) {
        decorated.setBody(body);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return decorated.getHeaders();
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        decorated.setHeaders(headers);
    }

    @Override
    public void addHeader(String name, String value) {
        decorated.addHeader(name, value);
    }

    @Override
    public Integer getReadTimeout() {
        return decorated.getReadTimeout();
    }
}
