/* **********************************************************
 * Copyright (c) 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient.ResponseCallback;
import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.protocol.common.http.FrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.ChunkedTransferEncodingFrameDeserializer;
import com.vmware.vapi.internal.protocol.common.http.impl.InputStreamBinaryInput;
import com.vmware.vapi.internal.util.io.IoUtil;

public class BioFramedResponseHandlingStrategy
        implements BioResponseHandlingStrategy {

    @Override
    public void handleContent(InputStream content,
                              ResponseCallback cb,
                              AbortHandle abortHandle,
                              String uri)
            throws IOException {
        try {
            FrameDeserializer frameDeserializer = new ChunkedTransferEncodingFrameDeserializer();
            BinaryInput input = new InputStreamBinaryInput(content);
            byte[] frame;
            while ((frame = frameDeserializer.readFrame(input)) != null) {
                cb.received(new ByteArrayInputStream(frame),
                            CorrelatingClient.NO_OP_CONTROL);
            }
        } finally {
            IoUtil.silentClose(content);
        }
    }
}
