/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.common;

import java.io.IOException;
import java.io.InputStream;

import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;

/**
 * Deserializer producing {@code DataValue} representation of the processed data.
 *
 * <p>This deserializer is "direct" in the sense that it only consumes the
 * stream and does not use any additional metadata about the expected
 * structure or the field types of the produced {@code DataValue} result.
 *
 * <p>Concrete implementations might use different formats for the
 * byte stream representation of the {@code DataValue} (e.g. JSON, XML,
 * or some binary format). The structure of the deserialized {@code DataValue}
 * might differ, depending on the capabilities of the chosen format.
 */
public interface DirectDeserializer {
    /**
     * Deserializes the provided input stream, using the provided builder
     * to hold the result.
     *
     * @param builder used to build and store the result while processing the stream
     * @param input stream to read the serialized data from
     * @throws JsonInvalidDataValueException
     * @throws IOException
     */
    void deserialize(DataValueBuilder builder, InputStream input) throws IOException;
}