/* **********************************************************************
 * Copyright (c) 2021 VMware, Inc. All rights reserved. -- VMware Confidential
 * **********************************************************************/
package com.vmware.vapi.internal.protocol.common;

/**
 * Recreates certain pieces of the {@code javax.xml.bind.DatatypeConverter} to
 * remove the VAPI dependencies to the xml.bind package.
 * <p/>
 * The implementations here in match the behavior of the OpenJDK implementations
 * but are not as efficient. They rely on other utilities in the JDK instead of
 * implementing the algorithms.
 */
public class XsdDatatypeConverter {

    /**
     * Recreates the {@code javax.xml.bind.DatatypeConverter#parseBoolean} as to
     * remove Java 8 dependency from the VAPI code. The code here in is simpler
     * but functional equivalent to the java implementation.
     * <p/>
     * Note that {@code IllegalArgumentException} is not thrown from this method
     * despite the documentation in the JDK.
     *
     * @see <a href=
     *      "https://github.com/AdoptOpenJDK/openjdk-jdk9/blob/master/jaxws/src/java.xml.bind/share/classes/javax/xml/bind/DatatypeConverterImpl.java#L258">DatatypeConverterImpl.java#L258</a>
     *
     * @param lexicalXSDBoolean string representing boolean value
     * @return true if the supplied value is string literal "1" or "true" with
     *         optional white leading or trailing blank space
     */
    public static boolean parseBoolean(String lexicalXSDBoolean) {
        String value = lexicalXSDBoolean.trim();
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        return false;

    }
}
