/* **********************************************************
 * Copyright 2012, 2019 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonError.java --
 *
 *      Helper Class to represent a JSON RPC 2.0 error object.
 */

package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.internal.util.Validate;

public final class JsonError {
    private final int code;
    private final String message;
    private final String data;

    /**
     * Constructor
     *
     * @param code JSON-RPC 2.0 error code
     * @param message Error message
     */
    public JsonError(int code, String message) {
        this(code, message, null);
    }

    /**
     * Constructor
     *
     * @param code JSON-RPC 2.0 error code
     * @param message Error message; must not be <code>null</code>
     * @param data additional information about the error
     */
    public JsonError(int code, String message, String data) {
        Validate.notNull(message);

        this.code = code;
        this.message = message;
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public String getData() {
        return data;
    }
}
