/* **********************************************************
 * Copyright 2014 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.common.json;

/**
 * Exception which is thrown when invalid/unexpected JSON sequence is
 * detected while parsing the <code>DataValue</code> JSON representation.
 *
 * <p>It is common for both the client and server, so should be handled
 * on both sides.
 */
public class JsonInvalidDataValueException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    public JsonInvalidDataValueException(String message) {
        super(message);
    }
}
