/* **********************************************************
 * Copyright 2009 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.server.rpc.http.common.impl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * Trust manager that can accept certificates based on thumbprints.
 * @see com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager
 *
 */
public class ThumbprintTrustManager implements X509TrustManager {

   private X509TrustManager _defaultTrustManager;

   public ThumbprintTrustManager(TrustManager[] trustManagers) {
      _defaultTrustManager = findDefaultTrustManager(trustManagers);
   }

   public boolean isClientTrusted(X509Certificate[] chain, String authType){
      boolean isTrusted = true;

      try {
         _defaultTrustManager.checkClientTrusted(chain, authType);
      } catch (CertificateException e) {
         isTrusted = false;
      }
      return isTrusted;
   }

   @Override
   public void checkClientTrusted(X509Certificate[] chain, String authType)
         throws CertificateException {
      /* This should always succeed. We are interested in the validation result
       * but from here we can not store and use it easy because the method
       * is invoked by JSSE.
       */
   }

   @Override
   public void checkServerTrusted(X509Certificate[] chain, String authType)
         throws CertificateException {
      _defaultTrustManager.checkServerTrusted(chain, authType);
   }

   @Override
   public X509Certificate[] getAcceptedIssuers() {
      //allow clients to send self-signed certificates
      return new X509Certificate[0];
   }

   private X509TrustManager findDefaultTrustManager(TrustManager[] trustManagers) {
      X509TrustManager x509TrustManager = null;

      for (TrustManager trustManager : trustManagers) {
         if (trustManager instanceof X509TrustManager) {
            x509TrustManager = (X509TrustManager) trustManager;
            break;
         }
      }

      if (x509TrustManager == null) {
         throw new IllegalStateException("Unable to find default trust manager");
      }

      return x509TrustManager;
   }
}
