/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.tracing;

import javax.servlet.http.HttpServletRequest;

import com.vmware.vapi.tracing.Tracer;

/**
 * Default implementation that creates no-operation {@link TracingSpan}s
 */
public class NoopTracer implements Tracer {

    public NoopTracer() {
    }

    @Override
    public TracingSpan attachServerSpan(HttpServletRequest request) {
        return TracingSpan.NO_OP;
    }

    @Override
    public TracingSpan createClientSpan(String name) {
        return TracingSpan.NO_OP;
    }
}
