/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.tracing;

/**
 * An interface which represents the currently mounted tracing scope. {@link #close()}
 * <p>
 * A typical scenario when this class will be used, is:
 * </p>
 *
 * <blockquote><code><pre>
 * try (TracingScope scope = tracingSpan.makeCurrent()) {
 *     ...
 * }
 * </pre></code></blockquote>
 */
public interface TracingScope extends AutoCloseable {

    /**
     * If tracing is disabled or we want to avoid performing operations on
     * Scopes, this special no-op instance can be used. It basically does
     * nothing -- every method invocation is a no-op.
     */
    public static final TracingScope NO_OP = new TracingScope() {
        @Override
        public void close() {
        }
    };

    @Override
    void close();
}
