/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.util.async;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.util.async.DecoratorAsyncHandle;

/**
 * Utility which applies a filter on the result before passing it to the
 * wrapped async handle.
 *
 * @param <T> result type of the async handle
 */
public abstract class FilterAsyncHandle<T> extends DecoratorAsyncHandle<T> {

    /**
     * Wraps an existing async handle.
     *
     * @param asyncHandle async handle which will be decorated
     */
    public FilterAsyncHandle(AsyncHandle<T> asyncHandle) {
        super(asyncHandle);
    }

    /**
     * Filters the result. If this method throws, the error will be propagated
     * to the decorated handle.
     *
     * @param result result object from {@link #setResult(Object)}
     * @return filtered result object
     */
    protected abstract T filterResult(T result);

    @Override
    public void setResult(T result) {
        RuntimeException error = null;
        T newResult = null;
        try {
            newResult = filterResult(result);
        } catch (RuntimeException ex) {
            error = ex;
        }
        if (error == null) {
            decorated.setResult(newResult);
        } else {
            decorated.setError(error);
        }
    }

}
