/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ResourceBundleProvider.java --
 *
 *      Strategy interface for resolving ResourceBundle for messages.
 */
package com.vmware.vapi.l10n;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * Strategy interface for resolving {@link ResourceBundle}s for messages.
 */
public interface ResourceBundleProvider {

    /**
     * Returns a <code>ResourceBundle</code> for the specified message ID
     * and locale.
     *
     * @param msgId identifier of the message to be resolved
     * @param locale target locale
     * @return <code>ResourceBundle</code> which contains data for the message
     */
    public ResourceBundle getResourceBundle(String msgId, Locale locale);
}
