/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * TemplateFormatter.java --
 *
 *      Strategy interface for formatting message templates
 */
package com.vmware.vapi.l10n;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/**
 * Strategy interface for formatting message templates (with placeholders for
 * arguments) for target locale.
 *
 * <p>Different implementation can support different formats for the template.
 */
public interface TemplateFormatter {

    /**
     * Formats a message template for the target locale.
     *
     * @param msgTemplate locale-specific message template
     * @param args arguments to substitute in the template
     * @param locale target locale; used to localize replaced <code>args</code>
     * @return formatted string
     * @throws LocalizationException if formatting failed
     */
    public String format(String msgTemplate, List<String> args, Locale locale);

    /**
     * Formats a message template for the target locale.
     *
     * @param msgTemplate locale-specific message template
     * @param args arguments to substitute in the template
     * @param locale target locale; used to localize replaced <code>args</code>
     * @param tz target time zone for date and time values; if {@code null}
     *        default {@link MessageFormat} behavior will be used
     * @return formatted string
     * @throws LocalizationException if formatting failed
     */
    public String format(String msgTemplate,
                         List<String> args,
                         Locale locale,
                         TimeZone tz);
}
