package com.vmware.vapi.protocol;

import com.vmware.vapi.core.*;

/**
 * This is the 'client' side of a remote protocol. Anyone wishing to make an RPC
 * will need to provide a Connection class that allows a user to connect, and
 * retrieve an ApiProvider to send calls to.
 */
public interface ProtocolConnection {

    /**
     * Disconnect from the remote side.
     */
    public void disconnect();

    /**
     * Once connected get an ApiProvider that can be used to make calls.
     */
    public ApiProvider getApiProvider();

    /**
     * Returns an <code>ApiProvider</code> stub which has both synchronous and
     * asynchronous method overloads.
     *
     * @return provider stub
     */
    public ApiProviderStub getApiProviderStub();
}
