/* **********************************************************
 * Copyright (c) 2015-2016,2018 VMware, Inc. All rights reserved. VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.client.http;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;

/**
 * Request pre-processor. Implementation of this interface can modify the
 * compiled {@link HttpRequest} that will be used for invoking the REST
 * operation. Example for this is an authentication processor.
 */
public interface RequestPreProcessor {

    /**
     * Pre-process {@link HttpRequest} before sending it to the caller.
     * <p>
     * Exceptions thrown from this method will be ignored.
     *
     * @param serviceId service identifier; must not be {@code null}
     * @param operationId operation identifier; must not be {@code null}
     * @param request that will be processed; must not be {@code null}
     * @param params with which the operation will be called; must not be {@code null}
     * @param executionContext for the operation invocation; must not be {@code null}
     * @return processed {@link HttpRequest}.
     */
    // TODO: the .internal HttpRequest is exposed in the public surface here
    //       https://bugzilla.eng.vmware.com/show_bug.cgi?id=2124336
    HttpRequest handle(String serviceId,
                       String operationId,
                       HttpRequest request,
                       DataValue params,
                       ExecutionContext executionContext);
}
