/* **********************************************************
 * Copyright (c) 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.client.http;

import com.vmware.vapi.core.HttpResponse;
import com.vmware.vapi.core.HttpResponseAccessor;

/**
 * Capturer for the raw REST response.
 */
public class ResponseExtractor implements HttpResponseAccessor {
    private HttpResponse response;

    @Override
    public void access(HttpResponse response) {
        this.response = response;
    }

    /**
     * @return the captured raw REST response
     */
    public HttpResponse getResponse() {
        return this.response;
    }
}
