/* **********************************************************
 * Copyright 2009-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.server.rpc.http;



/**
 * Enqueues requests and transmits queued responses
 */

public interface Server {

   /**
    * Specify the HTTP listening endpoints.
    *
    * @param endpoints The server will listen for requests on these
    *        endpoints.
    */
   void setEndpoints(Endpoint[] endpoints);

   /**
    * @param services
    */
   void setServices(Service[] services);

   /**
    * Set the filter chain.
    *
    * The filters applied in the order in, which they are listed. During request
    * processing filters that don't match the request path are skipped.
    *
    * @param filters list of filters.
    */
   void setFilters(Filter[] filters);

   /**
    * Set a server configurator class that allows a server add a custom
    * configuration
    *
    * @param serverConfig a ServerConfigurator to add custom configuration to
    *        the server
    */
   void setServerConfigurator(ServerConfigurator serverConfig);

   /**
    * Start the server.
    */
   void start() throws Exception;

   /**
    * Stop the server.
    */
   void stop() throws Exception;

   /**
    * Blocks the current thread until the server stops.
    */
   void join() throws Exception;
}
