/* **********************************************************
 * Copyright 2011-2012 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * ApiInterface.java --
 *
 *      vAPI interface operations.
 */

package com.vmware.vapi.provider;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;

/**
 * The <code>ApiInterface</code> interface provides introspection
 * APIs for a vAPI interface; it is implemented by API providers.
 */
public interface ApiInterface {

    /**
     * Returns the identifier for this interface.
     *
     * @return          interface identifier for this interface
     */
    public InterfaceIdentifier getIdentifier();

    /**
     * Returns the details for this interface.
     *
     * @return          interface details for this interface
     */
    public InterfaceDefinition getDefinition();

    /**
     * Returns method definition for the specified method identifier.
     *
     * @param methodId  identifier of the method
     * @return <code>MethodDefinition</code> representing details for the
     *         requested method; or <code>null</code> method is not available
     */
    public MethodDefinition getMethodDefinition(MethodIdentifier methodId);

    /**
     * Invokes a method and returns the result of that method invocation.
     *
     * @param ctx          execution context for method invocation
     * @param methodId     identifier of the method to invoke; if there is no
     *                     such method, an error will be returned
     * @param input        input data value
     * @param asyncHandle  handle used to return result or error
     */
    public void invoke(ExecutionContext ctx,
                       MethodIdentifier methodId,
                       DataValue input,
                       AsyncHandle<MethodResult> asyncHandle);

}