/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std;

/**
 * This class holds a single message parameter and formatting settings for it. The
 * class has fields for {@link java.lang.String}, {@code long}, {@code double},
 * date time and nested messages. Only one will be used depending on the type of
 * data sent. For date, {@code double} and {@code long} it is possible to set
 * additional formatting details.
 */
public final class LocalizationParam implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * The {@code DateTimeFormat} enumeration class lists possible date and time
     * formatting options. It combines the Unicode CLDR format types - full, long,
     * medium and short with 3 different presentations - date only, time only and
     * combined date and time presentation.
     *
     * <p> See {@link com.vmware.vapi.bindings.ApiEnumeration enumerated types description}.
     */
    public static final
    class DateTimeFormat extends com.vmware.vapi.bindings.ApiEnumeration<DateTimeFormat> {

        /**
         * Native Java {@code enum} representing this enumeration class.
         * Ordinals have no semantic meaning (your code should not rely on them).
         * <p>
         * See {@link #getEnumValue}.
         */
        public enum Values {
            /**
             * Represents {@link DateTimeFormat#SHORT_DATE}.
             */
            SHORT_DATE,

            /**
             * Represents {@link DateTimeFormat#MED_DATE}.
             */
            MED_DATE,

            /**
             * Represents {@link DateTimeFormat#LONG_DATE}.
             */
            LONG_DATE,

            /**
             * Represents {@link DateTimeFormat#FULL_DATE}.
             */
            FULL_DATE,

            /**
             * Represents {@link DateTimeFormat#SHORT_TIME}.
             */
            SHORT_TIME,

            /**
             * Represents {@link DateTimeFormat#MED_TIME}.
             */
            MED_TIME,

            /**
             * Represents {@link DateTimeFormat#LONG_TIME}.
             */
            LONG_TIME,

            /**
             * Represents {@link DateTimeFormat#FULL_TIME}.
             */
            FULL_TIME,

            /**
             * Represents {@link DateTimeFormat#SHORT_DATE_TIME}.
             */
            SHORT_DATE_TIME,

            /**
             * Represents {@link DateTimeFormat#MED_DATE_TIME}.
             */
            MED_DATE_TIME,

            /**
             * Represents {@link DateTimeFormat#LONG_DATE_TIME}.
             */
            LONG_DATE_TIME,

            /**
             * Represents {@link DateTimeFormat#FULL_DATE_TIME}.
             */
            FULL_DATE_TIME,

            /**
             * Special {@code enum} constant which is used to represent constants
             * that do not exist in this enumeration binding. For example if a
             * client receives an enumeration constant that only exists in the
             * newer version of the API of the server, the client source code will
             * see it represented by {@code _UNKNOWN} constant, because its version
             * of the native Java {@code enum} lacks the new constant.
             */
            _UNKNOWN,
        }


        /**
         * The date and time value will be formatted as short date, for example
         * <i>2019-01-28</i>
         */
        public static final DateTimeFormat SHORT_DATE = new DateTimeFormat("SHORT_DATE");

        /**
         * The date and time value will be formatted as medium date, for example <i>2019
         * Jan 28</i>
         */
        public static final DateTimeFormat MED_DATE = new DateTimeFormat("MED_DATE");

        /**
         * The date and time value will be formatted as long date, for example <i>2019 Jan
         * 28</i>
         */
        public static final DateTimeFormat LONG_DATE = new DateTimeFormat("LONG_DATE");

        /**
         * The date and time value will be formatted as full date, for example <i>2019 Jan
         * 28, Mon</i>
         */
        public static final DateTimeFormat FULL_DATE = new DateTimeFormat("FULL_DATE");

        /**
         * The date and time value will be formatted as short time, for example
         * <i>12:59</i>
         */
        public static final DateTimeFormat SHORT_TIME = new DateTimeFormat("SHORT_TIME");

        /**
         * The date and time value will be formatted as medium time, for example
         * <i>12:59:01</i>
         */
        public static final DateTimeFormat MED_TIME = new DateTimeFormat("MED_TIME");

        /**
         * The date and time value will be formatted as long time, for example <i>12:59:01
         * Z</i>
         */
        public static final DateTimeFormat LONG_TIME = new DateTimeFormat("LONG_TIME");

        /**
         * The date and time value will be formatted as full time, for example <i>12:59:01
         * Z</i>
         */
        public static final DateTimeFormat FULL_TIME = new DateTimeFormat("FULL_TIME");

        /**
         * The date and time value will be formatted as short date and time, for example
         * <i>2019-01-28 12:59</i>
         */
        public static final DateTimeFormat SHORT_DATE_TIME = new DateTimeFormat("SHORT_DATE_TIME");

        /**
         * The date and time value will be formatted as medium date and time, for example
         * <i>2019 Jan 28 12:59:01</i>
         */
        public static final DateTimeFormat MED_DATE_TIME = new DateTimeFormat("MED_DATE_TIME");

        /**
         * The date and time value will be formatted as long date and time, for example
         * <i>2019 Jan 28 12:59:01 Z</i>
         */
        public static final DateTimeFormat LONG_DATE_TIME = new DateTimeFormat("LONG_DATE_TIME");

        /**
         * The date and time value will be formatted as full date and time, for example
         * <i>2019 Jan 28, Mon 12:59:01 Z</i>
         */
        public static final DateTimeFormat FULL_DATE_TIME = new DateTimeFormat("FULL_DATE_TIME");

        private static final long serialVersionUID = 1L;

        private static final DateTimeFormat[] $VALUES = new DateTimeFormat[] {SHORT_DATE, MED_DATE, LONG_DATE, FULL_DATE, SHORT_TIME, MED_TIME, LONG_TIME, FULL_TIME, SHORT_DATE_TIME, MED_DATE_TIME, LONG_DATE_TIME, FULL_DATE_TIME};

        private static final java.util.Map<java.lang.String, DateTimeFormat> $NAME_TO_VALUE_MAP = com.vmware.vapi.bindings.ApiEnumeration.buildNameMap($VALUES);

        private DateTimeFormat() {
            super(Values._UNKNOWN.name());
        }

        private DateTimeFormat(java.lang.String name) {
            super(name);
        }

        /**
         * Retrieve all enumeration constants <b>pre-defined</b> by this enumeration class.
         * <p>
         * Additional instances might exist at runtime, for example to represent a
         * new constant added to this enumeration class in subsequent version of the
         * API. Such new constant is represented as instance of {@link DateTimeFormat}
         * but is not <b>pre-defined</b>.
         *
         * @return Array of all <b>pre-defined</b> enumeration constants. Never {@code null}.
         */
        public static DateTimeFormat[] values() {
            return $VALUES.clone();
        }

        /**
         * Returns the enumeration constant for the specified name.
         * <p>
         * If the name matches exactly the identifier used to declare an enumeration
         * constant from this enumeration class, the constant in question will be returned.
         * <p>
         * Otherwise, a new instance of {@link DateTimeFormat} will be returned for the
         * specified name, which will not be one of the <b>pre-defined</b> constant
         * instances. Such new instance maps to the {@link Values#_UNKNOWN}
         * {@code enum} constant from the native Java {@code enum}.
         *
         * @param name The name of the constant to return. Must not be {@code null}.
         * @return Enumeration constant for the specified name. Never {@code null}.
         */
        public static DateTimeFormat valueOf(java.lang.String name) {
            if (name == null) {
                throw new java.lang.NullPointerException();
            }
            DateTimeFormat predefined = $NAME_TO_VALUE_MAP.get(name);
            if (predefined != null) {
                return predefined;
            }
            return new DateTimeFormat(name);
        }

        /**
         * Checks if this enumeration constant is unknown. Unknown is a constant
         * that is not one of the <b>pre-defined</b> ones for this enumeration class.
         * Also see {@link #valueOf} and {@link #values}.
         *
         * @return {@code true} if this constant is unknown, and {@code false} otherwise.
         */
        public boolean isUnknown() {
            return getEnumValue() == Values._UNKNOWN;
        }

        /**
         * Returns a native Java {@code enum} constant representing this enumeration
         * constant. The result is useful for usual handling of Java {@code enum},
         * for example it can be used in {@code switch} statements.
         * <p>
         * If this enumeration constant is unknown, then {@link Values#_UNKNOWN}
         * {@code enum} constant is returned.
         * <p>
         * The native Java {@code enum} is {@link Values}.
         *
         * @return The Java {@code enum} constant. Never {@code null}.
         */
        public Values getEnumValue() {
            try {
                return Values.valueOf(name());
            } catch (IllegalArgumentException ex) {
                return Values._UNKNOWN;
            }
        }

        private java.lang.Object readResolve() {
            return valueOf(name());
        }
    }


    private java.lang.String s;

    private java.util.Calendar dt;

    private java.lang.Long i;

    private java.lang.Double d;

    private com.vmware.vapi.std.NestedLocalizableMessage l;

    private com.vmware.vapi.std.LocalizationParam.DateTimeFormat format;

    private java.lang.Long precision;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LocalizationParam() {
    }

    protected LocalizationParam(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * {@link java.lang.String} value associated with the parameter.
     *
     * this property will be set when {@link java.lang.String} value is used.
     *
     * @return The current value of the property.
     */
    public java.lang.String getS() {
        return this.s;
    }

    /**
     * {@link java.lang.String} value associated with the parameter.
     *
     * this property will be set when {@link java.lang.String} value is used.
     *
     * @param s New value for the property.
     */
    public void setS(java.lang.String s) {
        this.s = s;
    }

    /**
     * Date and time value associated with the parameter. Use the {@code getFormat()}
     * property to specify date and time display style.
     *
     * this property will be set when date and time value is used.
     *
     * @return The current value of the property.
     */
    public java.util.Calendar getDt() {
        return this.dt;
    }

    /**
     * Date and time value associated with the parameter. Use the {@code getFormat()}
     * property to specify date and time display style.
     *
     * this property will be set when date and time value is used.
     *
     * @param dt New value for the property.
     */
    public void setDt(java.util.Calendar dt) {
        this.dt = dt;
    }

    /**
     * {@code long} value associated with the parameter.
     *
     * this property will be set when {@code long} value is used.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getI() {
        return this.i;
    }

    /**
     * {@code long} value associated with the parameter.
     *
     * this property will be set when {@code long} value is used.
     *
     * @param i New value for the property.
     */
    public void setI(java.lang.Long i) {
        this.i = i;
    }

    /**
     * The {@code double} value associated with the parameter. The number of displayed
     * fractional digits is changed via {@code getPrecision()} property.
     *
     * this property will be set when {@code double} value is used.
     *
     * @return The current value of the property.
     */
    public java.lang.Double getD() {
        return this.d;
    }

    /**
     * The {@code double} value associated with the parameter. The number of displayed
     * fractional digits is changed via {@code getPrecision()} property.
     *
     * this property will be set when {@code double} value is used.
     *
     * @param d New value for the property.
     */
    public void setD(java.lang.Double d) {
        this.d = d;
    }

    /**
     * Nested localizable value associated with the parameter. This is useful construct
     * to convert to human readable localized form enumeration class and {@code
     * boolean} values. It can also be used for proper handling of pluralization and
     * gender forms in localization. Recursive {@code NestedLocalizableMessage}
     * instances can be used for localizing short lists of items.
     *
     * this property will be set when nested localization message value is used.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.std.NestedLocalizableMessage getL() {
        return this.l;
    }

    /**
     * Nested localizable value associated with the parameter. This is useful construct
     * to convert to human readable localized form enumeration class and {@code
     * boolean} values. It can also be used for proper handling of pluralization and
     * gender forms in localization. Recursive {@code NestedLocalizableMessage}
     * instances can be used for localizing short lists of items.
     *
     * this property will be set when nested localization message value is used.
     *
     * @param l New value for the property.
     */
    public void setL(com.vmware.vapi.std.NestedLocalizableMessage l) {
        this.l = l;
    }

    /**
     * Format associated with the date and time value in {@code getDt()} property. The
     * enumeration constant {@code SHORT_DATETIME} will be used as default.
     *
     * this may not be set if enumeration constant {@code SHORT_DATETIME} default
     * format is appropriate
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.std.LocalizationParam.DateTimeFormat getFormat() {
        return this.format;
    }

    /**
     * Format associated with the date and time value in {@code getDt()} property. The
     * enumeration constant {@code SHORT_DATETIME} will be used as default.
     *
     * this may not be set if enumeration constant {@code SHORT_DATETIME} default
     * format is appropriate
     *
     * @param format New value for the property.
     */
    public void setFormat(com.vmware.vapi.std.LocalizationParam.DateTimeFormat format) {
        this.format = format;
    }

    /**
     * Number of fractional digits to include in formatted {@code double} value.
     *
     * this will be set when exact precision is required for rendering {@code double}
     * numbers.
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPrecision() {
        return this.precision;
    }

    /**
     * Number of fractional digits to include in formatted {@code double} value.
     *
     * this will be set when exact precision is required for rendering {@code double}
     * numbers.
     *
     * @param precision New value for the property.
     */
    public void setPrecision(java.lang.Long precision) {
        this.precision = precision;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.vapi.std.StructDefinitions.localizationParam;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("s",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.s, this._getType().getField("s")));
        structValue.setField("dt",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.dt, this._getType().getField("dt")));
        structValue.setField("i",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.i, this._getType().getField("i")));
        structValue.setField("d",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.d, this._getType().getField("d")));
        structValue.setField("l",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.l, this._getType().getField("l")));
        structValue.setField("format",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.format, this._getType().getField("format")));
        structValue.setField("precision",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.precision, this._getType().getField("precision")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.vapi.std.StructDefinitions.localizationParam;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.StructDefinitions.localizationParam.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LocalizationParam _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LocalizationParam(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LocalizationParam _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LocalizationParam(structValue);
    }

    /**
     * Builder class for {@link LocalizationParam}.
     */
    public static final class Builder {
        private java.lang.String s;
        private java.util.Calendar dt;
        private java.lang.Long i;
        private java.lang.Double d;
        private com.vmware.vapi.std.NestedLocalizableMessage l;
        private com.vmware.vapi.std.LocalizationParam.DateTimeFormat format;
        private java.lang.Long precision;

        /**
         * Constructor with parameters for the required properties of
         * {@link LocalizationParam}.
         */
        public Builder() {
        }

        /**
         * {@link java.lang.String} value associated with the parameter.
         *
         * this property will be set when {@link java.lang.String} value is used.
         *
         * @param s New value for the property.
         */
        public Builder setS(java.lang.String s) {
            this.s = s;
            return this;
        }

        /**
         * Date and time value associated with the parameter. Use the {@code getFormat()}
         * property to specify date and time display style.
         *
         * this property will be set when date and time value is used.
         *
         * @param dt New value for the property.
         */
        public Builder setDt(java.util.Calendar dt) {
            this.dt = dt;
            return this;
        }

        /**
         * {@code long} value associated with the parameter.
         *
         * this property will be set when {@code long} value is used.
         *
         * @param i New value for the property.
         */
        public Builder setI(java.lang.Long i) {
            this.i = i;
            return this;
        }

        /**
         * The {@code double} value associated with the parameter. The number of displayed
         * fractional digits is changed via {@code getPrecision()} property.
         *
         * this property will be set when {@code double} value is used.
         *
         * @param d New value for the property.
         */
        public Builder setD(java.lang.Double d) {
            this.d = d;
            return this;
        }

        /**
         * Nested localizable value associated with the parameter. This is useful construct
         * to convert to human readable localized form enumeration class and {@code
         * boolean} values. It can also be used for proper handling of pluralization and
         * gender forms in localization. Recursive {@code NestedLocalizableMessage}
         * instances can be used for localizing short lists of items.
         *
         * this property will be set when nested localization message value is used.
         *
         * @param l New value for the property.
         */
        public Builder setL(com.vmware.vapi.std.NestedLocalizableMessage l) {
            this.l = l;
            return this;
        }

        /**
         * Format associated with the date and time value in {@code getDt()} property. The
         * enumeration constant {@code SHORT_DATETIME} will be used as default.
         *
         * this may not be set if enumeration constant {@code SHORT_DATETIME} default
         * format is appropriate
         *
         * @param format New value for the property.
         */
        public Builder setFormat(com.vmware.vapi.std.LocalizationParam.DateTimeFormat format) {
            this.format = format;
            return this;
        }

        /**
         * Number of fractional digits to include in formatted {@code double} value.
         *
         * this will be set when exact precision is required for rendering {@code double}
         * numbers.
         *
         * @param precision New value for the property.
         */
        public Builder setPrecision(java.lang.Long precision) {
            this.precision = precision;
            return this;
        }

        public LocalizationParam build() {
            LocalizationParam result = new LocalizationParam();
            result.setS(this.s);
            result.setDt(this.dt);
            result.setI(this.i);
            result.setD(this.d);
            result.setL(this.l);
            result.setFormat(this.format);
            result.setPrecision(this.precision);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("s", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("s",
                                                                                "s",
                                                                                "getS",
                                                                                "setS");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("dt", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DateTimeType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("dt",
                                                                                "dt",
                                                                                "getDt",
                                                                                "setDt");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("i", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("i",
                                                                                "i",
                                                                                "getI",
                                                                                "setI");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("d", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DoubleType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("d",
                                                                                "d",
                                                                                "getD",
                                                                                "setD");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("l", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.StructDefinitions.nestedLocalizableMessage; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("l",
                                                                                "l",
                                                                                "getL",
                                                                                "setL");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("format", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.EnumType("com.vmware.vapi.std.localization_param.date_time_format", com.vmware.vapi.std.LocalizationParam.DateTimeFormat.class)));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("format",
                                                                                "format",
                                                                                "getFormat",
                                                                                "setFormat");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("precision", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("precision",
                                                                                "precision",
                                                                                "getPrecision",
                                                                                "setPrecision");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.localization_param",
                                                            fields,
                                                            com.vmware.vapi.std.LocalizationParam.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

