/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.errors.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std.errors;

/**
 * The {@code Unauthorized} exception indicates that the user is not authorized to
 * perform the method. 
 * <p> API requests may include a security context containing
 * user credentials. For example, the user credentials could be a SAML token, a
 * user name and password, or the session identifier for a previously established
 * session. Invoking the method may require that the user identified by those
 * credentials has particular privileges on the method or on one or more resource
 * identifiers passed to the method. </p>
 * <p> Examples: </p><ul> <li>The method
 * requires that the user have one or more privileges on the method, but the user
 * identified by the credentials in the security context does not have the required
 * privileges. </li> <li>The method requires that the user have one or more
 * privileges on a resource identifier passed to the method, but the user
 * identified by the credentials in the security context does not have the required
 * privileges. </li> </ul> 
 * <p> </p>
 * <p> Counterexamples: </p><ul> <li>The SAML
 * token in the request's security context has expired. A {@link
 * com.vmware.vapi.std.errors.Unauthenticated} exception would be used instead.
 * </li> <li>The user name and password in the request's security context are
 * invalid. The {@link com.vmware.vapi.std.errors.Unauthenticated} exception would
 * be used instead. </li> <li>The session identifier in the request's security
 * context identifies a session that has expired. The {@link
 * com.vmware.vapi.std.errors.Unauthenticated} exception would be used instead.
 * </li> </ul> 
 * <p> For security reasons, the {@link
 * com.vmware.vapi.std.errors.Error#getData} property in this exception is {@code
 * null}, and the {@link com.vmware.vapi.std.errors.Error#getMessages} property in
 * this exception does not disclose why the user is not authorized to perform the
 * method. For example the messages would not disclose which privilege the user did
 * not have or which resource identifier the user did not have the required
 * privilege to access. The API documentation should indicate what privileges are
 * required.</p>
 */
public class Unauthorized extends com.vmware.vapi.std.errors.Error implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public Unauthorized(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages, com.vmware.vapi.bindings.Structure data) {
        this();
        this.setMessages(messages);
        this.setData(data);
    }

    /**
     * Default constructor.
     */
    public Unauthorized() {
        this((com.vmware.vapi.data.StructValue)null);
    }

    protected Unauthorized(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this(__dynamicStructureFields, com.vmware.vapi.std.errors.Error.Type.UNAUTHORIZED);
    }

    protected Unauthorized(com.vmware.vapi.data.StructValue __dynamicStructureFields, com.vmware.vapi.std.errors.Error.Type errorType) {
        super(__dynamicStructureFields, errorType);
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.ErrorType _getType() {
        return com.vmware.vapi.std.errors.StructDefinitions.unauthorized;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        super._updateDataValue(structValue);
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String getMessage() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.ErrorType} instance representing the static bindings
     * type for this <code>Error</code>.
     */
    public static com.vmware.vapi.bindings.type.ErrorType _getClassType() {
        return com.vmware.vapi.std.errors.StructDefinitions.unauthorized;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.errors.StructDefinitions.unauthorized.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.ErrorValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Unauthorized _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Unauthorized(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Unauthorized _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Unauthorized(structValue);
    }

    /**
     * Builder class for {@link Unauthorized}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.vapi.std.LocalizableMessage> messages;
        private com.vmware.vapi.bindings.Structure data;

        /**
         * Constructor with parameters for the required properties of
         * {@link Unauthorized}.
         */
        public Builder(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages) {
            this.messages = messages;
        }

        /**
         * Data to facilitate clients responding to the method reporting a standard
         * exception to indicating that it was unable to complete successfully. 
         * <p>
         * Methods may provide data that clients can use when responding to exceptions.
         * Since the data that clients need may be specific to the context of the method
         * reporting the exception, different methods that report the same exception may
         * provide different data in the exception. The documentation for each each method
         * will describe what, if any, data it provides for each exception it reports.
         * </p>
         * <p> The {@link com.vmware.vapi.std.errors.ArgumentLocations}, {@link
         * com.vmware.vapi.std.errors.FileLocations}, and {@link
         * com.vmware.vapi.std.errors.TransientIndication} classes are intended as possible
         * values for this property. {@link com.vmware.vapi.std.DynamicID} may also be
         * useful as a value for this property (although that is not its primary purpose).
         * Some interfaces may provide their own specific classes for use as the value of
         * this property when reporting exceptions from their methods.</p>
         *
         * Some methods will not set this property when reporting exceptions.
         *
         * @param data New value for the property.
         */
        public Builder setData(com.vmware.vapi.bindings.Structure data) {
            this.data = data;
            return this;
        }

        public Unauthorized build() {
            Unauthorized result = new Unauthorized();
            result.setMessages(this.messages);
            result.setData(this.data);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.ErrorType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("messages", new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.StructDefinitions.localizableMessage; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("messages",
                                                                                "messages",
                                                                                "getMessages",
                                                                                "setMessages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data",
                                                                                "data",
                                                                                "getData",
                                                                                "setData");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.EnumType("com.vmware.vapi.std.errors.error.type", com.vmware.vapi.std.errors.Error.Type.class)));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_type",
                                                                                "errorType",
                                                                                "getErrorType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.ErrorType("com.vmware.vapi.std.errors.unauthorized",
                                                           fields,
                                                           com.vmware.vapi.std.errors.Unauthorized.class,
                                                           fieldNameDetails);
    }
}

