/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.interposition.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std.interposition;

/**
 * Information about the result from an interposed operation invocation. All POST
 * interposers will receive an instance of this structure.
 */
public final class InvocationResult implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Type of the invocation result.
     *
     * <p> See {@link com.vmware.vapi.bindings.ApiEnumeration enumerated types description}.
     */
    public static final
    class ResultType extends com.vmware.vapi.bindings.ApiEnumeration<ResultType> {

        /**
         * Native Java {@code enum} representing this enumeration class.
         * Ordinals have no semantic meaning (your code should not rely on them).
         * <p>
         * See {@link #getEnumValue}.
         */
        public enum Values {
            /**
             * Represents {@link ResultType#NORMAL_RESULT}.
             */
            NORMAL_RESULT,

            /**
             * Represents {@link ResultType#ERROR_RESULT}.
             */
            ERROR_RESULT,

            /**
             * Special {@code enum} constant which is used to represent constants
             * that do not exist in this enumeration binding. For example if a
             * client receives an enumeration constant that only exists in the
             * newer version of the API of the server, the client source code will
             * see it represented by {@code _UNKNOWN} constant, because its version
             * of the native Java {@code enum} lacks the new constant.
             */
            _UNKNOWN,
        }


        /**
         * Normal invocation result.
         */
        public static final ResultType NORMAL_RESULT = new ResultType("NORMAL_RESULT");

        /**
         * Error invocation result.
         */
        public static final ResultType ERROR_RESULT = new ResultType("ERROR_RESULT");

        private static final long serialVersionUID = 1L;

        private static final ResultType[] $VALUES = new ResultType[] {NORMAL_RESULT, ERROR_RESULT};

        private static final java.util.Map<java.lang.String, ResultType> $NAME_TO_VALUE_MAP = com.vmware.vapi.bindings.ApiEnumeration.buildNameMap($VALUES);

        private ResultType() {
            super(Values._UNKNOWN.name());
        }

        private ResultType(java.lang.String name) {
            super(name);
        }

        /**
         * Retrieve all enumeration constants <b>pre-defined</b> by this enumeration class.
         * <p>
         * Additional instances might exist at runtime, for example to represent a
         * new constant added to this enumeration class in subsequent version of the
         * API. Such new constant is represented as instance of {@link ResultType}
         * but is not <b>pre-defined</b>.
         *
         * @return Array of all <b>pre-defined</b> enumeration constants. Never {@code null}.
         */
        public static ResultType[] values() {
            return $VALUES.clone();
        }

        /**
         * Returns the enumeration constant for the specified name.
         * <p>
         * If the name matches exactly the identifier used to declare an enumeration
         * constant from this enumeration class, the constant in question will be returned.
         * <p>
         * Otherwise, a new instance of {@link ResultType} will be returned for the
         * specified name, which will not be one of the <b>pre-defined</b> constant
         * instances. Such new instance maps to the {@link Values#_UNKNOWN}
         * {@code enum} constant from the native Java {@code enum}.
         *
         * @param name The name of the constant to return. Must not be {@code null}.
         * @return Enumeration constant for the specified name. Never {@code null}.
         */
        public static ResultType valueOf(java.lang.String name) {
            if (name == null) {
                throw new java.lang.NullPointerException();
            }
            ResultType predefined = $NAME_TO_VALUE_MAP.get(name);
            if (predefined != null) {
                return predefined;
            }
            return new ResultType(name);
        }

        /**
         * Checks if this enumeration constant is unknown. Unknown is a constant
         * that is not one of the <b>pre-defined</b> ones for this enumeration class.
         * Also see {@link #valueOf} and {@link #values}.
         *
         * @return {@code true} if this constant is unknown, and {@code false} otherwise.
         */
        public boolean isUnknown() {
            return getEnumValue() == Values._UNKNOWN;
        }

        /**
         * Returns a native Java {@code enum} constant representing this enumeration
         * constant. The result is useful for usual handling of Java {@code enum},
         * for example it can be used in {@code switch} statements.
         * <p>
         * If this enumeration constant is unknown, then {@link Values#_UNKNOWN}
         * {@code enum} constant is returned.
         * <p>
         * The native Java {@code enum} is {@link Values}.
         *
         * @return The Java {@code enum} constant. Never {@code null}.
         */
        public Values getEnumValue() {
            try {
                return Values.valueOf(name());
            } catch (IllegalArgumentException ex) {
                return Values._UNKNOWN;
            }
        }

        private java.lang.Object readResolve() {
            return valueOf(name());
        }
    }


    private com.vmware.vapi.std.interposition.InvocationResult.ResultType resultType;

    private com.vmware.vapi.data.DataValue output;

    private com.vmware.vapi.bindings.Structure error;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public InvocationResult(com.vmware.vapi.std.interposition.InvocationResult.ResultType resultType, com.vmware.vapi.data.DataValue output, com.vmware.vapi.bindings.Structure error) {
        this();
        this.resultType = resultType;
        this.output = output;
        this.error = error;
    }

    /**
     * Default constructor.
     */
    public InvocationResult() {
    }

    protected InvocationResult(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Type of the invocation result.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.std.interposition.InvocationResult.ResultType getResultType() {
        return this.resultType;
    }

    /**
     * Type of the invocation result.
     *
     * @param resultType New value for the property.
     */
    public void setResultType(com.vmware.vapi.std.interposition.InvocationResult.ResultType resultType) {
        this.resultType = resultType;
    }

    /**
     * Normal result value.
     *
     * This property is optional and it is only relevant when the value of {@code
     * getResultType()} is {@link
     * com.vmware.vapi.std.interposition.InvocationResult.ResultType#NORMAL_RESULT}.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.data.DataValue getOutput() {
        return this.output;
    }

    /**
     * Normal result value.
     *
     * This property is optional and it is only relevant when the value of {@code
     * getResultType()} is {@link
     * com.vmware.vapi.std.interposition.InvocationResult.ResultType#NORMAL_RESULT}.
     *
     * @param output New value for the property.
     */
    public void setOutput(com.vmware.vapi.data.DataValue output) {
        this.output = output;
    }

    /**
     * Error result value.
     *
     * This property is optional and it is only relevant when the value of {@code
     * getResultType()} is {@link
     * com.vmware.vapi.std.interposition.InvocationResult.ResultType#ERROR_RESULT}.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.bindings.Structure getError() {
        return this.error;
    }

    /**
     * Error result value.
     *
     * This property is optional and it is only relevant when the value of {@code
     * getResultType()} is {@link
     * com.vmware.vapi.std.interposition.InvocationResult.ResultType#ERROR_RESULT}.
     *
     * @param error New value for the property.
     */
    public void setError(com.vmware.vapi.bindings.Structure error) {
        this.error = error;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.vapi.std.interposition.StructDefinitions.invocationResult;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("result_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resultType, this._getType().getField("result_type")));
        structValue.setField("output",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.output, this._getType().getField("output")));
        structValue.setField("error",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.error, this._getType().getField("error")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.vapi.std.interposition.StructDefinitions.invocationResult;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.interposition.StructDefinitions.invocationResult.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static InvocationResult _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new InvocationResult(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static InvocationResult _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new InvocationResult(structValue);
    }

    /**
     * Builder class for {@link InvocationResult}.
     */
    public static final class Builder {
        private com.vmware.vapi.std.interposition.InvocationResult.ResultType resultType;
        private com.vmware.vapi.data.DataValue output;
        private com.vmware.vapi.bindings.Structure error;

        /**
         * Constructor with parameters for the required properties of
         * {@link InvocationResult}.
         */
        public Builder(com.vmware.vapi.std.interposition.InvocationResult.ResultType resultType) {
            this.resultType = resultType;
        }

        /**
         * Normal result value.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getResultType()} is {@link
         * com.vmware.vapi.std.interposition.InvocationResult.ResultType#NORMAL_RESULT}.
         *
         * @param output New value for the property.
         */
        public Builder setOutput(com.vmware.vapi.data.DataValue output) {
            this.output = output;
            return this;
        }

        /**
         * Error result value.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getResultType()} is {@link
         * com.vmware.vapi.std.interposition.InvocationResult.ResultType#ERROR_RESULT}.
         *
         * @param error New value for the property.
         */
        public Builder setError(com.vmware.vapi.bindings.Structure error) {
            this.error = error;
            return this;
        }

        public InvocationResult build() {
            InvocationResult result = new InvocationResult();
            result.setResultType(this.resultType);
            result.setOutput(this.output);
            result.setError(this.error);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<String, java.util.List<com.vmware.vapi.internal.data.UnionValidator.FieldData>> caseFields = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("result_type", new com.vmware.vapi.bindings.type.EnumType("com.vmware.vapi.std.interposition.invocation_result.result_type", com.vmware.vapi.std.interposition.InvocationResult.ResultType.class));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("result_type",
                                                                                "resultType",
                                                                                "getResultType",
                                                                                "setResultType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("output", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.OpaqueType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("output",
                                                                                "output",
                                                                                "getOutput",
                                                                                "setOutput");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error",
                                                                                "error",
                                                                                "getError",
                                                                                "setError");
        fieldNameDetails.put(details.getCanonicalName(), details);
        validators = new java.util.ArrayList<com.vmware.vapi.internal.data.ConstraintValidator>(1);
        caseFields = new java.util.HashMap<String, java.util.List<com.vmware.vapi.internal.data.UnionValidator.FieldData>>();
        caseFields.put("NORMAL_RESULT", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("output", false)));
        caseFields.put("ERROR_RESULT", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("error", false)));
        validators.add(new com.vmware.vapi.internal.data.UnionValidator("result_type",
                                                                        caseFields));
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.interposition.invocation_result",
                                                            fields,
                                                            com.vmware.vapi.std.interposition.InvocationResult.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

