/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.vapi.std.introspection.
 * Used by client-side stubs.
 */

package com.vmware.vapi.std.introspection;

/**
 * The {@link com.vmware.vapi.std.introspection.Operation} service provides
 * operations to retrieve information about the operations present in a vAPI
 * service.
 */
public interface Operation extends com.vmware.vapi.bindings.Service, com.vmware.vapi.std.introspection.OperationTypes {

    /**
     * Returns the set of operation identifiers for a given vAPI service.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @return set of operation identifiers for a given vAPI service.
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist.
     */
    public java.util.Set<java.lang.String> list(java.lang.String serviceId);

    /**
     * Returns the set of operation identifiers for a given vAPI service.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param invocationConfig Configuration for the method invocation.
     * @return set of operation identifiers for a given vAPI service.
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist.
     */
    public java.util.Set<java.lang.String> list(java.lang.String serviceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the set of operation identifiers for a given vAPI service.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * set of operation identifiers for a given vAPI service.
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.operation}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist.<br>
     * </p>
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String serviceId, com.vmware.vapi.bindings.client.AsyncCallback<java.util.Set<java.lang.String>> asyncCallback);

    /**
     * Returns the set of operation identifiers for a given vAPI service.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * set of operation identifiers for a given vAPI service.
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.operation}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist.<br>
     * </p>
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String serviceId, com.vmware.vapi.bindings.client.AsyncCallback<java.util.Set<java.lang.String>> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a
     * given vAPI operation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param operationId operation identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @return {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a given vAPI
     * operation.
     * @throws com.vmware.vapi.std.errors.NotFound If the operation identifier does not exist.
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist.
     */
    public com.vmware.vapi.std.introspection.OperationTypes.Info get(java.lang.String serviceId, java.lang.String operationId);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a
     * given vAPI operation.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param operationId operation identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @param invocationConfig Configuration for the method invocation.
     * @return {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a given vAPI
     * operation.
     * @throws com.vmware.vapi.std.errors.NotFound If the operation identifier does not exist.
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist.
     */
    public com.vmware.vapi.std.introspection.OperationTypes.Info get(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a
     * given vAPI operation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a given vAPI
     * operation.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the operation identifier does not exist.<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist.<br>
     * </p>
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param operationId operation identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.std.introspection.OperationTypes.Info> asyncCallback);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a
     * given vAPI operation.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a given vAPI
     * operation.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the operation identifier does not exist.<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist.<br>
     * </p>
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param operationId operation identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.std.introspection.OperationTypes.Info> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
