/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 * Used by server-side asynchronous skeletons.
 */

package com.vmware.vapi.std.introspection;

/**
 * The {@link com.vmware.vapi.std.introspection.OperationProvider} service provides
 * operations to retrieve information about the operations present in a vAPI
 * service.
 */
@com.vmware.vapi.bindings.annotation.ProviderFor(value=com.vmware.vapi.std.introspection.OperationApiInterface.class)
public interface OperationProvider extends com.vmware.vapi.bindings.Service, com.vmware.vapi.std.introspection.OperationTypes {

    /**
     * Returns the set of operation identifiers for a given vAPI service.
     *
     * <p><b>Invocation Result</b>:<br>
     * set of operation identifiers for a given vAPI service.
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.operation}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist.<br>
     * </p>
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param asyncContext Handle to report the progress, result or error of the operation invocation.
     */
    public void list(java.lang.String serviceId, com.vmware.vapi.bindings.server.AsyncContext<java.util.Set<java.lang.String>> asyncContext);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a
     * given vAPI operation.
     *
     * <p><b>Invocation Result</b>:<br>
     * {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a given vAPI
     * operation.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the operation identifier does not exist.<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist.<br>
     * </p>
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param operationId operation identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @param asyncContext Handle to report the progress, result or error of the operation invocation.
     */
    public void get(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.bindings.server.AsyncContext<com.vmware.vapi.std.introspection.OperationTypes.Info> asyncContext);

}
