
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 */

package com.vmware.vapi.std.introspection;

/**
 * Implementation of {@link com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton} which
 * adapts API service implementation (class that implements
 * the generated {@link com.vmware.vapi.std.introspection.OperationSyncProvider} interface).
 *
 * <p>This adapter expects synchronous API service implementation.</p>
 */
public class OperationSyncApiInterface extends com.vmware.vapi.internal.bindings.ApiInterfaceSkeleton {
    private com.vmware.vapi.std.introspection.OperationSyncProvider impl;

    private class ListApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public ListApiMethod() {
            super(OperationSyncApiInterface.this.getIdentifier(),
                  "list", com.vmware.vapi.std.introspection.OperationDefinitions.__listInput,
                  com.vmware.vapi.std.introspection.OperationDefinitions.__listOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.introspection.OperationDefinitions.__listInput,
                                                                               getTypeConverter());
            java.lang.String serviceId = extr.<java.lang.String>valueForField("service_id");
            try {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newResult(getTypeConverter().convertToVapi(impl.list(serviceId, invocationContext),
                                                                                                                   com.vmware.vapi.std.introspection.OperationDefinitions.__listOutput,
                                                                                                                   new com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            } catch (java.lang.RuntimeException ex) {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newErrorResult(toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    private class GetApiMethod extends com.vmware.vapi.internal.bindings.ApiMethodSkeleton {
        public GetApiMethod() {
            super(OperationSyncApiInterface.this.getIdentifier(),
                  "get", com.vmware.vapi.std.introspection.OperationDefinitions.__getInput,
                  com.vmware.vapi.std.introspection.OperationDefinitions.__getOutput,
                  getTypeConverter(),
                  java.util.Arrays.<com.vmware.vapi.bindings.type.Type>asList(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.errors.StructDefinitions.notFound; } }),
                  com.vmware.vapi.core.MethodDefinition.TaskSupport.NONE);
        }

        @java.lang.Override
        public void doInvoke(com.vmware.vapi.bindings.server.InvocationContext invocationContext,
                             com.vmware.vapi.data.StructValue inStruct,
                             com.vmware.vapi.core.AsyncHandle<com.vmware.vapi.core.MethodResult> asyncHandle) {
            com.vmware.vapi.internal.bindings.StructValueExtractor extr =
                    new com.vmware.vapi.internal.bindings.StructValueExtractor(inStruct,
                                                                               com.vmware.vapi.std.introspection.OperationDefinitions.__getInput,
                                                                               getTypeConverter());
            java.lang.String serviceId = extr.<java.lang.String>valueForField("service_id");
            java.lang.String operationId = extr.<java.lang.String>valueForField("operation_id");
            try {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newResult(getTypeConverter().convertToVapi(impl.get(serviceId, operationId, invocationContext),
                                                                                                                   com.vmware.vapi.std.introspection.OperationDefinitions.__getOutput,
                                                                                                                   new com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext(invocationContext.getExecutionContext()))));
            } catch (java.lang.RuntimeException ex) {
                asyncHandle.setResult(com.vmware.vapi.core.MethodResult.newErrorResult(toErrorValue(ex, invocationContext.getExecutionContext())));
            }
        }
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationSyncApiInterface} instance with
     * default API service implementation.
     * <p>
     * The default service implementation is assumed to be
     * instance of the {@code com.vmware.vapi.std.introspection.impl.OperationImpl} class. This
     * class will be loaded and instantiated.
     */
    public OperationSyncApiInterface() {
        this((java.lang.Class<com.vmware.vapi.std.introspection.OperationSyncProvider>) null);
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationSyncApiInterface} instance
     * for specified {@code class} of the API service implementation. The
     * specified class will be instantiated.
     *
     * @param implClass The {@code Class} implementing {@link com.vmware.vapi.std.introspection.OperationSyncProvider}
     *                  API service. If {@code null} default implementation will be
     *                  used as in {@link #OperationSyncApiInterface()}.
     */
    public OperationSyncApiInterface(java.lang.Class<? extends com.vmware.vapi.std.introspection.OperationSyncProvider> implClass) {
        this(createImplInstance(implClass,
                                "com.vmware.vapi.std.introspection.impl.OperationImpl",
                                com.vmware.vapi.std.introspection.OperationSyncProvider.class));
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationSyncApiInterface} instance
     * for specified instance of the API service implementation.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.OperationSyncProvider}
     *             API service. Must not be {@code null}.
     */
    public OperationSyncApiInterface(com.vmware.vapi.std.introspection.OperationSyncProvider impl) {
        this(impl,  new com.vmware.vapi.internal.bindings.TypeConverterImpl());
    }

    /**
     * Constructor.
     *
     * Creates an {@link OperationSyncApiInterface} instance
     * for specified instance of the API service implementation and custom conversion logic.
     *
     * @param impl The implementation of {@link com.vmware.vapi.std.introspection.OperationSyncProvider}
     *             API service. Must not be {@code null}.
     * @param converter logic to convert from native to wire type and back. Must not be {@code null}.
     */
    public OperationSyncApiInterface(com.vmware.vapi.std.introspection.OperationSyncProvider impl,
            com.vmware.vapi.internal.bindings.TypeConverter converter) {
        super("com.vmware.vapi.std.introspection.operation", converter);

        com.vmware.vapi.internal.util.Validate.notNull(impl);
        this.impl = impl;

        registerMethod(new ListApiMethod());
        registerMethod(new GetApiMethod());
   }
}

