
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Used by server-side synchronous skeletons.
 */

package com.vmware.vapi.std.introspection;

/**
 * The {@link com.vmware.vapi.std.introspection.OperationSyncProvider} service
 * provides operations to retrieve information about the operations present in a
 * vAPI service.
 */
@com.vmware.vapi.bindings.annotation.ProviderFor(value=com.vmware.vapi.std.introspection.OperationSyncApiInterface.class)
public interface OperationSyncProvider extends com.vmware.vapi.bindings.Service, com.vmware.vapi.std.introspection.OperationTypes {

    /**
     * Returns the set of operation identifiers for a given vAPI service.
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param invocationConfig Configuration for the method invocation.
     * @return set of operation identifiers for a given vAPI service.
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist.
     */
    public java.util.Set<java.lang.String> list(java.lang.String serviceId, com.vmware.vapi.bindings.server.InvocationContext invocationContext);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a
     * given vAPI operation.
     *
     * @param serviceId service identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param operationId operation identifier.
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.operation}.
     * @param invocationConfig Configuration for the method invocation.
     * @return {@link com.vmware.vapi.std.introspection.OperationTypes.Info} for a given vAPI
     * operation.
     * @throws com.vmware.vapi.std.errors.NotFound If the operation identifier does not exist.
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist.
     */
    public com.vmware.vapi.std.introspection.OperationTypes.Info get(java.lang.String serviceId, java.lang.String operationId, com.vmware.vapi.bindings.server.InvocationContext invocationContext);

}
