/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 * Contains only data type definitions and no methods.
 * Shared by client-side stubs and server-side skeletons to ensure type
 * compatibility.
 */

package com.vmware.vapi.std.introspection;

/**
 * Defines the data types of the {@link Operation}
 * API service.
 */
/**
 * The {@link com.vmware.vapi.std.introspection.Operation} service provides
 * operations to retrieve information about the operations present in a vAPI
 * service.
 */
public interface OperationTypes {
    /**
     * Identifier of the service
     */
    public static final String _VAPI_SERVICE_ID = "com.vmware.vapi.std.introspection.operation";

    /**
     * The {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
     * structure describes a vAPI data type.
     */
    public static final class DataDefinition implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

        private static final long serialVersionUID = 1L;

        /**
         * The {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType}
         * enumeration provides values representing the data types supported by the vAPI
         * infrastructure.
         *
         * <p> See {@link com.vmware.vapi.bindings.ApiEnumeration enumerated types description}.
         */
        public static final
        class DataType extends com.vmware.vapi.bindings.ApiEnumeration<DataType> {

            /**
             * Native Java {@code enum} representing this enumeration class.
             * Ordinals have no semantic meaning (your code should not rely on them).
             * <p>
             * See {@link #getEnumValue}.
             */
            public enum Values {
                /**
                 * Represents {@link DataType#BINARY}.
                 */
                BINARY,

                /**
                 * Represents {@link DataType#BOOLEAN}.
                 */
                BOOLEAN,

                /**
                 * Represents {@link DataType#DOUBLE}.
                 */
                DOUBLE,

                /**
                 * Represents {@link DataType#DYNAMIC_STRUCTURE}.
                 */
                DYNAMIC_STRUCTURE,

                /**
                 * Represents {@link DataType#ERROR}.
                 */
                ERROR,

                /**
                 * Represents {@link DataType#ANY_ERROR}.
                 */
                ANY_ERROR,

                /**
                 * Represents {@link DataType#LIST}.
                 */
                LIST,

                /**
                 * Represents {@link DataType#LONG}.
                 */
                LONG,

                /**
                 * Represents {@link DataType#OPAQUE}.
                 */
                OPAQUE,

                /**
                 * Represents {@link DataType#OPTIONAL}.
                 */
                OPTIONAL,

                /**
                 * Represents {@link DataType#SECRET}.
                 */
                SECRET,

                /**
                 * Represents {@link DataType#STRING}.
                 */
                STRING,

                /**
                 * Represents {@link DataType#STRUCTURE}.
                 */
                STRUCTURE,

                /**
                 * Represents {@link DataType#STRUCTURE_REF}.
                 */
                STRUCTURE_REF,

                /**
                 * Represents {@link DataType#VOID}.
                 */
                VOID,

                /**
                 * Special {@code enum} constant which is used to represent constants
                 * that do not exist in this enumeration binding. For example if a
                 * client receives an enumeration constant that only exists in the
                 * newer version of the API of the server, the client source code will
                 * see it represented by {@code _UNKNOWN} constant, because its version
                 * of the native Java {@code enum} lacks the new constant.
                 */
                _UNKNOWN,
            }


            /**
             * Indicates the value is a binary type.
             */
            public static final DataType BINARY = new DataType("BINARY");

            /**
             * Indicates the value is a boolean type. The possible values are True and False
             * equivalent of the language used to invoke this operation.
             */
            public static final DataType BOOLEAN = new DataType("BOOLEAN");

            /**
             * Indicates the value is a double type. It is a 64 bit floating point number.
             */
            public static final DataType DOUBLE = new DataType("DOUBLE");

            /**
             * Indicates the value is a dynamic structure. This means, any data of type {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE}
             * can be used.
             */
            public static final DataType DYNAMIC_STRUCTURE = new DataType("DYNAMIC_STRUCTURE");

            /**
             * Indicates the value is a specific error type.
             */
            public static final DataType ERROR = new DataType("ERROR");

            /**
             * Indicates the value is arbitrary error type. This means, any data of type {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}
             * can be used.
             */
            public static final DataType ANY_ERROR = new DataType("ANY_ERROR");

            /**
             * Indicates the value is a list data type. Any value of this type can have zero or
             * more elements in the list.
             */
            public static final DataType LIST = new DataType("LIST");

            /**
             * Indicates the value is a long data type. It is a 64 bit signed integer number.
             */
            public static final DataType LONG = new DataType("LONG");

            /**
             * Indicates the value is an opaque type. This means, data of any {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType} can be
             * used.
             */
            public static final DataType OPAQUE = new DataType("OPAQUE");

            /**
             * Indicates the value is an optional data type. Any value of this type can be
             * null.
             */
            public static final DataType OPTIONAL = new DataType("OPTIONAL");

            /**
             * Indicates the value is a secret data type. This is used for sensitive
             * information. The server will not log any data of this type and if possible wipe
             * the data from the memory after usage.
             */
            public static final DataType SECRET = new DataType("SECRET");

            /**
             * Indicates the value is a string data type. This is a unicode string.
             */
            public static final DataType STRING = new DataType("STRING");

            /**
             * Indicates the value is a structure data type. A structure has string identifier
             * and a set of fields with corresponding values.
             */
            public static final DataType STRUCTURE = new DataType("STRUCTURE");

            /**
             * Indicates the value is a structure reference. This is used to break circular
             * dependencies in the type references. This just has a string identifier of the
             * structure. Clients have to maintain a list of structures already visited and use
             * that to resolve this reference.
             */
            public static final DataType STRUCTURE_REF = new DataType("STRUCTURE_REF");

            /**
             * Indicates the value is a void data type.
             */
            public static final DataType VOID = new DataType("VOID");

            private static final long serialVersionUID = 1L;

            private static final DataType[] $VALUES = new DataType[] {BINARY, BOOLEAN, DOUBLE, DYNAMIC_STRUCTURE, ERROR, ANY_ERROR, LIST, LONG, OPAQUE, OPTIONAL, SECRET, STRING, STRUCTURE, STRUCTURE_REF, VOID};

            private static final java.util.Map<java.lang.String, DataType> $NAME_TO_VALUE_MAP = com.vmware.vapi.bindings.ApiEnumeration.buildNameMap($VALUES);

            private DataType() {
                super(Values._UNKNOWN.name());
            }

            private DataType(java.lang.String name) {
                super(name);
            }

            /**
             * Retrieve all enumeration constants <b>pre-defined</b> by this enumeration class.
             * <p>
             * Additional instances might exist at runtime, for example to represent a
             * new constant added to this enumeration class in subsequent version of the
             * API. Such new constant is represented as instance of {@link DataType}
             * but is not <b>pre-defined</b>.
             *
             * @return Array of all <b>pre-defined</b> enumeration constants. Never {@code null}.
             */
            public static DataType[] values() {
                return $VALUES.clone();
            }

            /**
             * Returns the enumeration constant for the specified name.
             * <p>
             * If the name matches exactly the identifier used to declare an enumeration
             * constant from this enumeration class, the constant in question will be returned.
             * <p>
             * Otherwise, a new instance of {@link DataType} will be returned for the
             * specified name, which will not be one of the <b>pre-defined</b> constant
             * instances. Such new instance maps to the {@link Values#_UNKNOWN}
             * {@code enum} constant from the native Java {@code enum}.
             *
             * @param name The name of the constant to return. Must not be {@code null}.
             * @return Enumeration constant for the specified name. Never {@code null}.
             */
            public static DataType valueOf(java.lang.String name) {
                if (name == null) {
                    throw new java.lang.NullPointerException();
                }
                DataType predefined = $NAME_TO_VALUE_MAP.get(name);
                if (predefined != null) {
                    return predefined;
                }
                return new DataType(name);
            }

            /**
             * Checks if this enumeration constant is unknown. Unknown is a constant
             * that is not one of the <b>pre-defined</b> ones for this enumeration class.
             * Also see {@link #valueOf} and {@link #values}.
             *
             * @return {@code true} if this constant is unknown, and {@code false} otherwise.
             */
            public boolean isUnknown() {
                return getEnumValue() == Values._UNKNOWN;
            }

            /**
             * Returns a native Java {@code enum} constant representing this enumeration
             * constant. The result is useful for usual handling of Java {@code enum},
             * for example it can be used in {@code switch} statements.
             * <p>
             * If this enumeration constant is unknown, then {@link Values#_UNKNOWN}
             * {@code enum} constant is returned.
             * <p>
             * The native Java {@code enum} is {@link Values}.
             *
             * @return The Java {@code enum} constant. Never {@code null}.
             */
            public Values getEnumValue() {
                try {
                    return Values.valueOf(name());
                } catch (IllegalArgumentException ex) {
                    return Values._UNKNOWN;
                }
            }

            private java.lang.Object readResolve() {
                return valueOf(name());
            }
        }


        private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType type;

        private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition elementDefinition;

        private java.lang.String name;

        private java.util.Map<java.lang.String, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> fields;

        protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

        /**
         * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
         */
        public DataDefinition(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType type, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition elementDefinition, java.lang.String name, java.util.Map<java.lang.String, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> fields) {
            this();
            this.type = type;
            this.elementDefinition = elementDefinition;
            this.name = name;
            this.fields = fields;
        }

        /**
         * Default constructor.
         */
        public DataDefinition() {
        }

        protected DataDefinition(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
            this.__dynamicStructureFields = __dynamicStructureFields;
        }


        /**
         * Data type of the value.
         *
         * @return The current value of the property.
         */
        public com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType getType() {
            return this.type;
        }

        /**
         * Data type of the value.
         *
         * @param type New value for the property.
         */
        public void setType(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType type) {
            this.type = type;
        }

        /**
         * Contains the element definition for generic data types like List and Optional.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getType()} is one of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#OPTIONAL}
         * or {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#LIST}.
         *
         * @return The current value of the property.
         */
        public com.vmware.vapi.std.introspection.OperationTypes.DataDefinition getElementDefinition() {
            return this.elementDefinition;
        }

        /**
         * Contains the element definition for generic data types like List and Optional.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getType()} is one of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#OPTIONAL}
         * or {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#LIST}.
         *
         * @param elementDefinition New value for the property.
         */
        public void setElementDefinition(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition elementDefinition) {
            this.elementDefinition = elementDefinition;
        }

        /**
         * Fully qualified name of the structure.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getType()} is one of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE},
         * {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE_REF},
         * or {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.
         *
         * @return The current value of the property.
         */
        public java.lang.String getName() {
            return this.name;
        }

        /**
         * Fully qualified name of the structure.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getType()} is one of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE},
         * {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE_REF},
         * or {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.
         *
         * @param name New value for the property.
         */
        public void setName(java.lang.String name) {
            this.name = name;
        }

        /**
         * Fields of the structure type. The key of the map is the canonical name of the
         * field and the value is the {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition} for the field.
         * The order of the structure fields defined in IDL is not maintained by the {@link
         * com.vmware.vapi.std.introspection.Operation} service.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getType()} is one of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE}
         * or {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.
         *
         * @return The current value of the property.
         */
        public java.util.Map<java.lang.String, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> getFields() {
            return this.fields;
        }

        /**
         * Fields of the structure type. The key of the map is the canonical name of the
         * field and the value is the {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition} for the field.
         * The order of the structure fields defined in IDL is not maintained by the {@link
         * com.vmware.vapi.std.introspection.Operation} service.
         *
         * This property is optional and it is only relevant when the value of {@code
         * getType()} is one of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE}
         * or {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.
         *
         * @param fields New value for the property.
         */
        public void setFields(java.util.Map<java.lang.String, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> fields) {
            this.fields = fields;
        }

       @java.lang.Override
        public com.vmware.vapi.bindings.type.StructType _getType() {
            return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition;
        }

        @java.lang.Override
        public com.vmware.vapi.data.StructValue _getDataValue() {
            com.vmware.vapi.data.StructValue dataValue;
            if (__dynamicStructureFields != null) {
                dataValue = __dynamicStructureFields.copy();
            } else {
                dataValue = createEmptyStructValue();
            }
            this._updateDataValue(dataValue);
            return dataValue;
        }

        protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
            structValue.setField("type",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.type, this._getType().getField("type")));
            structValue.setField("element_definition",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.elementDefinition, this._getType().getField("element_definition")));
            structValue.setField("name",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.name, this._getType().getField("name")));
            structValue.setField("fields",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.fields, this._getType().getField("fields")));
        }

        @java.lang.Override
        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        @java.lang.Override
        public boolean equals(java.lang.Object obj) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
        }

        @java.lang.Override
        public int hashCode() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
        }

        @java.lang.Override
        public java.lang.String toString() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
        }

        @java.lang.Override
        public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
        }

        @java.lang.Override
        public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
        }

        @java.lang.Override
        public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
            if (_getType().getFieldNames().contains(fieldName)) {
                 throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
            }
            if(__dynamicStructureFields == null) {
                __dynamicStructureFields = createEmptyStructValue();
            }
            __dynamicStructureFields.setField(fieldName, fieldValue);
        }

        @java.lang.Override
        public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
            if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
                throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
            }
            return __dynamicStructureFields.getField(fieldName);
        }

        @java.lang.Override
        public java.util.Set<java.lang.String> _getDynamicFieldNames() {
            if (__dynamicStructureFields == null) {
                return java.util.Collections.<java.lang.String>emptySet();
            }
            return __dynamicStructureFields.getFieldNames();
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.
         *
         * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
         * type for this <code>Structure</code>.
         */
        public static com.vmware.vapi.bindings.type.StructType _getClassType() {
            return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition;
        }

        @java.lang.Override
        public java.lang.String _getCanonicalName() {
            if (__dynamicStructureFields != null) {
                return __dynamicStructureFields.getName();
            }
            return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition.getName();
        }

        /**
         * Returns the canonical type name. See {@link #_getCanonicalName()}.
         *
         * @return canonical type name
         */
        public static java.lang.String _getCanonicalTypeName() {
            return _getClassType().getName();
        }

        private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
            return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         *
         * Returns new instance of this binding class and injects the provided data value.<br>
         *
         * <b>WARNING:</b> The returned object is not fully initialized.<br>
         *
         * @param structValue the source of the data contained in the binding object. Could
         *                    contain more data than fields of this class can describe i.e.
         *                    newer version of the binding object. Could be null.
         * @return the static bindings <code>StructType</code>
         */
        public static DataDefinition _newInstance(com.vmware.vapi.data.StructValue structValue) {
            return new DataDefinition(structValue);
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         * Serves as a versioning mechanism.
         */
        public static DataDefinition _newInstance2(com.vmware.vapi.data.StructValue structValue) {
            return new DataDefinition(structValue);
        }

        /**
         * Builder class for {@link DataDefinition}.
         */
        public static final class Builder {
            private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType type;
            private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition elementDefinition;
            private java.lang.String name;
            private java.util.Map<java.lang.String, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> fields;

            /**
             * Constructor with parameters for the required properties of
             * {@link DataDefinition}.
             */
            public Builder(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType type) {
                this.type = type;
            }

            /**
             * Contains the element definition for generic data types like List and Optional.
             *
             * This property is optional and it is only relevant when the value of {@code
             * getType()} is one of {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#OPTIONAL}
             * or {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#LIST}.
             *
             * @param elementDefinition New value for the property.
             */
            public Builder setElementDefinition(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition elementDefinition) {
                this.elementDefinition = elementDefinition;
                return this;
            }

            /**
             * Fully qualified name of the structure.
             *
             * This property is optional and it is only relevant when the value of {@code
             * getType()} is one of {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE},
             * {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE_REF},
             * or {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.
             *
             * @param name New value for the property.
             */
            public Builder setName(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Fields of the structure type. The key of the map is the canonical name of the
             * field and the value is the {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition} for the field.
             * The order of the structure fields defined in IDL is not maintained by the {@link
             * com.vmware.vapi.std.introspection.Operation} service.
             *
             * This property is optional and it is only relevant when the value of {@code
             * getType()} is one of {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE}
             * or {@link
             * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.
             *
             * @param fields New value for the property.
             */
            public Builder setFields(java.util.Map<java.lang.String, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> fields) {
                this.fields = fields;
                return this;
            }

            public DataDefinition build() {
                DataDefinition result = new DataDefinition();
                result.setType(this.type);
                result.setElementDefinition(this.elementDefinition);
                result.setName(this.name);
                result.setFields(this.fields);
                return result;
            }
        }


        static com.vmware.vapi.bindings.type.StructType __initStructType() {
            com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
            java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
            java.util.Map<String, java.util.List<com.vmware.vapi.internal.data.UnionValidator.FieldData>> caseFields = null;
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
            fields.put("type", new com.vmware.vapi.bindings.type.EnumType("com.vmware.vapi.std.introspection.operation.data_definition.data_type", com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType.class));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                    "type",
                                                                                    "getType",
                                                                                    "setType");
            fieldNameDetails.put(details.getCanonicalName(), details);
            fields.put("element_definition", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition; } }));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("element_definition",
                                                                                    "elementDefinition",
                                                                                    "getElementDefinition",
                                                                                    "setElementDefinition");
            fieldNameDetails.put(details.getCanonicalName(), details);
            fields.put("name", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("name",
                                                                                    "name",
                                                                                    "getName",
                                                                                    "setName");
            fieldNameDetails.put(details.getCanonicalName(), details);
            fields.put("fields", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.MapType(new com.vmware.vapi.bindings.type.StringType(), new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition; } })));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("fields",
                                                                                    "fields",
                                                                                    "getFields",
                                                                                    "setFields");
            fieldNameDetails.put(details.getCanonicalName(), details);
            validators = new java.util.ArrayList<com.vmware.vapi.internal.data.ConstraintValidator>(1);
            caseFields = new java.util.HashMap<String, java.util.List<com.vmware.vapi.internal.data.UnionValidator.FieldData>>();
            caseFields.put("OPTIONAL", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("element_definition", false)));
            caseFields.put("LIST", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("element_definition", false)));
            caseFields.put("STRUCTURE", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("name", false), new com.vmware.vapi.internal.data.UnionValidator.FieldData("fields", false)));
            caseFields.put("STRUCTURE_REF", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("name", false)));
            caseFields.put("ERROR", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList(new com.vmware.vapi.internal.data.UnionValidator.FieldData("name", false), new com.vmware.vapi.internal.data.UnionValidator.FieldData("fields", false)));
            caseFields.put("BINARY", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("BOOLEAN", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("DOUBLE", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("DYNAMIC_STRUCTURE", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("ANY_ERROR", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("LONG", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("OPAQUE", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("SECRET", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("STRING", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            caseFields.put("VOID", java.util.Arrays.<com.vmware.vapi.internal.data.UnionValidator.FieldData>asList());
            validators.add(new com.vmware.vapi.internal.data.UnionValidator("type",
                                                                            caseFields));
            return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.introspection.operation.data_definition",
                                                                fields,
                                                                com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.class,
                                                                validators,
                                                                false,
                                                                null,
                                                                fieldNameDetails,
                                                                null,
                                                                null);
        }
    }

    /**
     * Information about a vAPI operation.
     */
    public static final class Info implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

        private static final long serialVersionUID = 1L;

        private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition inputDefinition;

        private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition outputDefinition;

        private java.util.List<com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> errorDefinitions;

        protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

        /**
         * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
         */
        public Info(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition inputDefinition, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition outputDefinition, java.util.List<com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> errorDefinitions) {
            this();
            this.inputDefinition = inputDefinition;
            this.outputDefinition = outputDefinition;
            this.errorDefinitions = errorDefinitions;
        }

        /**
         * Default constructor.
         */
        public Info() {
        }

        protected Info(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
            this.__dynamicStructureFields = __dynamicStructureFields;
        }


        /**
         * {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
         * describing the operation input. 
         * <p> The {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getType} of this
         * field will be {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE}.
         * The keys of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getFields} are
         * the names of the operation parameters, and the values of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getFields}
         * describe the type of the operation parameters.</p>
         *
         * @return The current value of the property.
         */
        public com.vmware.vapi.std.introspection.OperationTypes.DataDefinition getInputDefinition() {
            return this.inputDefinition;
        }

        /**
         * {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
         * describing the operation input. 
         * <p> The {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getType} of this
         * field will be {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#STRUCTURE}.
         * The keys of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getFields} are
         * the names of the operation parameters, and the values of {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getFields}
         * describe the type of the operation parameters.</p>
         *
         * @param inputDefinition New value for the property.
         */
        public void setInputDefinition(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
        }

        /**
         * {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
         * describing the operation output.
         *
         * @return The current value of the property.
         */
        public com.vmware.vapi.std.introspection.OperationTypes.DataDefinition getOutputDefinition() {
            return this.outputDefinition;
        }

        /**
         * {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
         * describing the operation output.
         *
         * @param outputDefinition New value for the property.
         */
        public void setOutputDefinition(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition outputDefinition) {
            this.outputDefinition = outputDefinition;
        }

        /**
         * List of {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
         * describing the errors that the operation might report. 
         * <p> The {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getType} of
         * every element in this list will be {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.</p>
         *
         * @return The current value of the property.
         */
        public java.util.List<com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> getErrorDefinitions() {
            return this.errorDefinitions;
        }

        /**
         * List of {@link com.vmware.vapi.std.introspection.OperationTypes.DataDefinition}
         * describing the errors that the operation might report. 
         * <p> The {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition#getType} of
         * every element in this list will be {@link
         * com.vmware.vapi.std.introspection.OperationTypes.DataDefinition.DataType#ERROR}.</p>
         *
         * @param errorDefinitions New value for the property.
         */
        public void setErrorDefinitions(java.util.List<com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> errorDefinitions) {
            this.errorDefinitions = errorDefinitions;
        }

       @java.lang.Override
        public com.vmware.vapi.bindings.type.StructType _getType() {
            return com.vmware.vapi.std.introspection.OperationDefinitions.info;
        }

        @java.lang.Override
        public com.vmware.vapi.data.StructValue _getDataValue() {
            com.vmware.vapi.data.StructValue dataValue;
            if (__dynamicStructureFields != null) {
                dataValue = __dynamicStructureFields.copy();
            } else {
                dataValue = createEmptyStructValue();
            }
            this._updateDataValue(dataValue);
            return dataValue;
        }

        protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
            structValue.setField("input_definition",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.inputDefinition, this._getType().getField("input_definition")));
            structValue.setField("output_definition",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.outputDefinition, this._getType().getField("output_definition")));
            structValue.setField("error_definitions",
                    com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                            this.errorDefinitions, this._getType().getField("error_definitions")));
        }

        @java.lang.Override
        public void _validate() {
            this._getType().validate(this._getDataValue());
        }

        @java.lang.Override
        public boolean equals(java.lang.Object obj) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
        }

        @java.lang.Override
        public int hashCode() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
        }

        @java.lang.Override
        public java.lang.String toString() {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
        }

        @java.lang.Override
        public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
        }

        @java.lang.Override
        public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
            return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
        }

        @java.lang.Override
        public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
            if (_getType().getFieldNames().contains(fieldName)) {
                 throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
            }
            if(__dynamicStructureFields == null) {
                __dynamicStructureFields = createEmptyStructValue();
            }
            __dynamicStructureFields.setField(fieldName, fieldValue);
        }

        @java.lang.Override
        public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
            if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
                throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
            }
            return __dynamicStructureFields.getField(fieldName);
        }

        @java.lang.Override
        public java.util.Set<java.lang.String> _getDynamicFieldNames() {
            if (__dynamicStructureFields == null) {
                return java.util.Collections.<java.lang.String>emptySet();
            }
            return __dynamicStructureFields.getFieldNames();
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.
         *
         * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
         * type for this <code>Structure</code>.
         */
        public static com.vmware.vapi.bindings.type.StructType _getClassType() {
            return com.vmware.vapi.std.introspection.OperationDefinitions.info;
        }

        @java.lang.Override
        public java.lang.String _getCanonicalName() {
            if (__dynamicStructureFields != null) {
                return __dynamicStructureFields.getName();
            }
            return com.vmware.vapi.std.introspection.OperationDefinitions.info.getName();
        }

        /**
         * Returns the canonical type name. See {@link #_getCanonicalName()}.
         *
         * @return canonical type name
         */
        public static java.lang.String _getCanonicalTypeName() {
            return _getClassType().getName();
        }

        private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
            return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         *
         * Returns new instance of this binding class and injects the provided data value.<br>
         *
         * <b>WARNING:</b> The returned object is not fully initialized.<br>
         *
         * @param structValue the source of the data contained in the binding object. Could
         *                    contain more data than fields of this class can describe i.e.
         *                    newer version of the binding object. Could be null.
         * @return the static bindings <code>StructType</code>
         */
        public static Info _newInstance(com.vmware.vapi.data.StructValue structValue) {
            return new Info(structValue);
        }

        /**
         * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
         * Serves as a versioning mechanism.
         */
        public static Info _newInstance2(com.vmware.vapi.data.StructValue structValue) {
            return new Info(structValue);
        }

        /**
         * Builder class for {@link Info}.
         */
        public static final class Builder {
            private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition inputDefinition;
            private com.vmware.vapi.std.introspection.OperationTypes.DataDefinition outputDefinition;
            private java.util.List<com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> errorDefinitions;

            /**
             * Constructor with parameters for the required properties of
             * {@link Info}.
             */
            public Builder(com.vmware.vapi.std.introspection.OperationTypes.DataDefinition inputDefinition, com.vmware.vapi.std.introspection.OperationTypes.DataDefinition outputDefinition, java.util.List<com.vmware.vapi.std.introspection.OperationTypes.DataDefinition> errorDefinitions) {
                this.inputDefinition = inputDefinition;
                this.outputDefinition = outputDefinition;
                this.errorDefinitions = errorDefinitions;
            }

            public Info build() {
                Info result = new Info();
                result.setInputDefinition(this.inputDefinition);
                result.setOutputDefinition(this.outputDefinition);
                result.setErrorDefinitions(this.errorDefinitions);
                return result;
            }
        }


        static com.vmware.vapi.bindings.type.StructType __initStructType() {
            com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
            java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
            java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
            fields.put("input_definition", new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition; } });
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("input_definition",
                                                                                    "inputDefinition",
                                                                                    "getInputDefinition",
                                                                                    "setInputDefinition");
            fieldNameDetails.put(details.getCanonicalName(), details);
            fields.put("output_definition", new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition; } });
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("output_definition",
                                                                                    "outputDefinition",
                                                                                    "getOutputDefinition",
                                                                                    "setOutputDefinition");
            fieldNameDetails.put(details.getCanonicalName(), details);
            fields.put("error_definitions", new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.introspection.OperationDefinitions.dataDefinition; } }));
            details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_definitions",
                                                                                    "errorDefinitions",
                                                                                    "getErrorDefinitions",
                                                                                    "setErrorDefinitions");
            fieldNameDetails.put(details.getCanonicalName(), details);
            return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.introspection.operation.info",
                                                                fields,
                                                                com.vmware.vapi.std.introspection.OperationTypes.Info.class,
                                                                validators,
                                                                false,
                                                                null,
                                                                fieldNameDetails,
                                                                null,
                                                                null);
        }
    }

}
