/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.vapi.std.introspection.
 * Used by client-side stubs.
 */

package com.vmware.vapi.std.introspection;

/**
 * The {@link com.vmware.vapi.std.introspection.Service} service provides
 * operations to retrieve information about the services exposed by a vAPI
 * provider. A provider is a container that exposes one or more vAPI services.
 */
public interface Service extends com.vmware.vapi.bindings.Service, com.vmware.vapi.std.introspection.ServiceTypes {

    /**
     * Returns the set of service identifiers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return set of service identifiers
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.service}.
     */
    public java.util.Set<java.lang.String> list();

    /**
     * Returns the set of service identifiers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return set of service identifiers
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.service}.
     */
    public java.util.Set<java.lang.String> list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the set of service identifiers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * set of service identifiers
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.service}.
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<java.util.Set<java.lang.String>> asyncCallback);

    /**
     * Returns the set of service identifiers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * set of service identifiers
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.service}.
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<java.util.Set<java.lang.String>> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the
     * specified service
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param id service identifier
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @return {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the specified
     * service
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist
     */
    public com.vmware.vapi.std.introspection.ServiceTypes.Info get(java.lang.String id);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the
     * specified service
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param id service identifier
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param invocationConfig Configuration for the method invocation.
     * @return {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the specified
     * service
     * @throws com.vmware.vapi.std.errors.NotFound If the service identifier does not exist
     */
    public com.vmware.vapi.std.introspection.ServiceTypes.Info get(java.lang.String id, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns the {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the
     * specified service
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the specified
     * service
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist<br>
     * </p>
     *
     * @param id service identifier
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.std.introspection.ServiceTypes.Info> asyncCallback);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the
     * specified service
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the specified
     * service
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist<br>
     * </p>
     *
     * @param id service identifier
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String id, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.std.introspection.ServiceTypes.Info> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
