/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.introspection.
 * Used by server-side asynchronous skeletons.
 */

package com.vmware.vapi.std.introspection;

/**
 * The {@link com.vmware.vapi.std.introspection.ServiceProvider} service provides
 * operations to retrieve information about the services exposed by a vAPI
 * provider. A provider is a container that exposes one or more vAPI services.
 */
@com.vmware.vapi.bindings.annotation.ProviderFor(value=com.vmware.vapi.std.introspection.ServiceApiInterface.class)
public interface ServiceProvider extends com.vmware.vapi.bindings.Service, com.vmware.vapi.std.introspection.ServiceTypes {

    /**
     * Returns the set of service identifiers.
     *
     * <p><b>Invocation Result</b>:<br>
     * set of service identifiers
     * The return value will contain identifiers for the resource type: {@code
     * com.vmware.vapi.service}.
     * </p>
     *
     * @param asyncContext Handle to report the progress, result or error of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.server.AsyncContext<java.util.Set<java.lang.String>> asyncContext);

    /**
     * Returns the {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the
     * specified service
     *
     * <p><b>Invocation Result</b>:<br>
     * {@link com.vmware.vapi.std.introspection.ServiceTypes.Info} for the specified
     * service
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.NotFound} - If the service identifier does not exist<br>
     * </p>
     *
     * @param id service identifier
     * The parameter must be an identifier for the resource type: {@code
     * com.vmware.vapi.service}.
     * @param asyncContext Handle to report the progress, result or error of the operation invocation.
     */
    public void get(java.lang.String id, com.vmware.vapi.bindings.server.AsyncContext<com.vmware.vapi.std.introspection.ServiceTypes.Info> asyncContext);

}
