/* **********************************************************
 * Copyright 2022 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.tracing;

import javax.servlet.http.HttpServletRequest;

import com.vmware.vapi.internal.tracing.NoopTracer;
import com.vmware.vapi.internal.tracing.TracingSpan;

/**
 * An interface for the creation of {@link TracingSpan} spans used by the vapi
 * stack
 */
public interface Tracer {

    Tracer NO_OP = new NoopTracer();

    /**
     * Creates a new client span and associates it with the current tracing
     * context. If there is no current tracing context, then the newly created
     * span becomes the root.
     * <p>
     * {@link TracingSpan#makeCurrent()} must be called to activate the span.
     *
     * @return the created {@link TracingSpan}
     */
    TracingSpan createClientSpan(String name);

    /**
     * Creates a new server span and attaches it to the tracer propagated with
     * the http request. If there is no tracer propagated with the request, then
     * the newly created span becomes the root.
     * <p>
     * {@link TracingSpan#makeCurrent()} must be called to activate the span.
     *
     * @param request the request to extract the tracer ID from
     * @return the attached {@link TracingSpan}
     */
    TracingSpan attachServerSpan(HttpServletRequest request);
}
