/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.DynamicStructureImpl;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import com.vmware.vapi.internal.util.Validate;

public final class StaticStructureDynamicStructureConverter
implements UniTypeConverter<StructValue, DynamicStructType> {
    private final NameToTypeResolver resolver;

    public StaticStructureDynamicStructureConverter(NameToTypeResolver resolver) {
        Validate.notNull(resolver);
        this.resolver = resolver;
    }

    @Override
    public Object fromValue(StructValue value, DynamicStructType declaredType, TypeConverter typeConverter) {
        Type type = this.resolver.resolve(value.getName());
        if (type != null) {
            return typeConverter.convertToJava(value, type);
        }
        return new DynamicStructureImpl(value, typeConverter);
    }

    @Override
    public DataValue toValue(Object binding, DynamicStructType declaredType, TypeConverter typeConverter, TypeConverter.ConversionContext cc) {
        if (binding instanceof StaticStructure) {
            StaticStructure struct = (StaticStructure)binding;
            StructType type = struct._getType();
            return typeConverter.convertToVapi(binding, type, cc);
        }
        Structure struct = ConvertUtil.narrowType(binding, Structure.class);
        return struct._getDataValue();
    }
}

