/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.internal.protocol.client.rest.RequestExecutor;
import com.vmware.vapi.internal.protocol.client.rest.RequestExecutorFactory;
import com.vmware.vapi.internal.protocol.client.rest.ResponseParser;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;
import com.vmware.vapi.internal.protocol.common.msg.JsonMessageProtocolExceptionTranslator;
import java.util.Objects;

public class DefaultRequestExecutorFactory
implements RequestExecutorFactory {
    @Override
    public RequestExecutor createRequestExecutor(RestTransport transport, ResponseParser parser) {
        return new DefaultRequestExecutor(transport, parser);
    }

    public static class DefaultHttpResponseHandler
    implements HttpRequest.HttpResponseHandler {
        protected final ResponseParser parser;
        protected final String serviceId;
        protected final String operationId;
        protected final AsyncHandle<MethodResult> asyncHandle;

        public DefaultHttpResponseHandler(ResponseParser parser, String serviceId, String operationId, AsyncHandle<MethodResult> asyncHandle) {
            this.parser = Objects.requireNonNull(parser);
            this.serviceId = Objects.requireNonNull(serviceId);
            this.operationId = Objects.requireNonNull(operationId);
            this.asyncHandle = Objects.requireNonNull(asyncHandle);
        }

        @Override
        public void onResult(HttpResponse response) {
            this.asyncHandle.setResult(this.parser.parse(this.serviceId, this.operationId, response));
        }

        @Override
        public void onError(Exception ex) {
            this.asyncHandle.setError(JsonMessageProtocolExceptionTranslator.translate(ex));
        }
    }

    private static class DefaultRequestExecutor
    implements RequestExecutor {
        private final RestTransport transport;
        private final ResponseParser parser;

        DefaultRequestExecutor(RestTransport transport, ResponseParser parser) {
            this.transport = transport;
            this.parser = parser;
        }

        @Override
        public void execute(String serviceId, String operationId, HttpRequest request, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
            this.transport.execute(Objects.requireNonNull(request), new DefaultHttpResponseHandler(this.parser, serviceId, operationId, asyncHandle), ctx);
        }
    }
}

