/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http;

import com.vmware.vapi.internal.util.Validate;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

final class KeyManagerWrapper
extends X509ExtendedKeyManager {
    private final X509KeyManager baseKM;
    private final String alias;

    public KeyManagerWrapper(X509KeyManager baseKM, String alias) {
        Validate.notNull(baseKM);
        this.baseKM = baseKM;
        this.alias = alias;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (null == this.alias) {
            return this.baseKM.chooseClientAlias(keyType, issuers, socket);
        }
        if (this.isAliasFound(keyType, issuers)) {
            return this.alias;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.baseKM.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.baseKM.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.baseKM.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.baseKM.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.baseKM.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine sslEngine) {
        if (null == this.alias || !this.isAliasFound(keyType, issuers)) {
            return super.chooseEngineClientAlias(keyType, issuers, sslEngine);
        }
        return this.alias;
    }

    private boolean isAliasFound(String[] keyType, Principal[] issuers) {
        for (int i = 0; i < keyType.length; ++i) {
            String[] validAliases = this.baseKM.getClientAliases(keyType[i], issuers);
            if (validAliases == null) continue;
            for (int j = 0; j < validAliases.length; ++j) {
                if (!validAliases[j].equals(this.alias)) continue;
                return true;
            }
        }
        return false;
    }
}

