/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CappedInputBuffer
extends SimpleInputBuffer {
    private static final Logger logger = LoggerFactory.getLogger(CappedInputBuffer.class);
    private final int maxBuffSize;
    private final ByteBufferAllocator allocator;

    CappedInputBuffer(int maxBufferSize, int initBufferSize, ByteBufferAllocator allocator) {
        super(initBufferSize, allocator);
        if (initBufferSize > maxBufferSize) {
            throw new IllegalArgumentException("initBufferSize " + initBufferSize + " cannot be bigger than maxBufferSize " + maxBufferSize);
        }
        if (maxBufferSize <= 0) {
            throw new IllegalArgumentException("maxBufferSIze must be a positive number");
        }
        this.maxBuffSize = maxBufferSize;
        this.allocator = allocator;
    }

    protected void expand() throws BufferOverflowException {
        int newCapacity = this.buffer.capacity() << 1;
        if (newCapacity < 0) {
            int vmBytes = 8;
            int javaBytes = 8;
            int headRoom = 8;
            newCapacity = 0x7FFFFFF7;
            if (newCapacity <= this.buffer.capacity()) {
                throw new BufferOverflowException();
            }
        }
        this.expandCapacity(newCapacity);
    }

    private void expandCapacity(int capacity) {
        if (capacity > this.maxBuffSize) {
            logger.warn("Buffer size exceeded. Allowed: " + this.maxBuffSize + " requested: " + capacity);
            throw new BufferOverflowException();
        }
        ByteBuffer oldbuffer = this.buffer;
        this.buffer = this.allocator.allocate(capacity);
        oldbuffer.flip();
        this.buffer.put(oldbuffer);
    }
}

