﻿# Copyright (c) Omnissa, LLC. All rights reserved.
# This product is protected by copyright and intellectual property laws in the
# United States and other countries as well as by international treaties.
# -- Omnissa Restricted

param (
    [string]$InstallRunnerFile,
    [string]$sourceServer,
    [string]$msiArgs,
    [string]$installDir,
    [string]$installerFilename,
    [string]$version,
    [string]$buildNumber,
    [string]$url,
    [string]$expectedFileSize,
    [string]$expectedChecksum,
    [string]$triggerMethodName,
    [string]$scheduleTaskAfter,
    [string]$username,
    [securestring]$securePassword,
    [string]$vdmRegKeyPath,
    [string]$lcmRegKeyPath,
    [string]$programData

)
   
$Credentials = New-Object System.Management.Automation.PSCredential -ArgumentList $username, $securePassword
$extractedPassword = $Credentials.GetNetworkCredential().Password

$vdmRegKeyEncodedPath = [Convert]::ToBase64String([Text.Encoding]::UTF8.GetBytes($vdmRegKeyPath))
$lcmRegKeyEncodedPath = [Convert]::ToBase64String([Text.Encoding]::UTF8.GetBytes($lcmRegKeyPath))

$arguments = "-NoProfile -ExecutionPolicy Bypass -File ""$InstallRunnerFile"" -sourceServer ""$sourceServer"" -installerFilename ""$installerFilename"" -version ""$version"" -buildNumber ""$buildNumber"" -url ""$url"" -msiArgs ""$msiArgs"" -installDir ""$installDir"" -expectedFileSize ""$expectedFileSize"" -expectedChecksum ""$expectedChecksum"" -horizonRegKeyEncodedPath ""$vdmRegKeyEncodedPath"" -lcmRegKeyEncodedPath ""$lcmRegKeyEncodedPath"" -programData ""$programData"""
$Action = New-ScheduledTaskAction -Execute 'PowerShell.exe' -Argument $arguments

try {
    $Trigger = New-ScheduledTaskTrigger -Once -At (Get-Date)."$triggerMethodName"("$scheduleTaskAfter")
    $TaskName = "RunHorizonServerInstall"
    $TaskExists = Get-ScheduledTask -TaskName $TaskName -ErrorAction SilentlyContinue
    if ($TaskExists) {
        try {
            Unregister-ScheduledTask -TaskName $TaskName -Confirm:$false -ErrorAction Stop
            Write-Output "Previously scheduled task '$TaskName' deleted successfully."
        }
        catch {
            Write-Error "FAIL - Failed to delete task '$TaskName'. Error: $_"
            exit 1
        }
    }
    Register-ScheduledTask -TaskName $TaskName -Action $Action -Trigger $Trigger -Description "Horizon Server Install Task" -User "$username" -Password  $extractedPassword -Force 
    if (Get-ScheduledTask -TaskName $TaskName -ErrorAction SilentlyContinue) {
        Set-ItemProperty -Path $lcmRegKeyPath -Name "Status" -Value "Horizon_Server_Install_Scheduled"
        Write-Host "PASS - Horizon Server Install Task created successfully."
    }
    else {
        Set-ItemProperty -Path $lcmRegKeyPath -Name "Status" -Value "Failed_To_Schedule_Horizon_Server_Install"
        Set-ItemProperty -Path $lcmRegKeyPath -Name "ControllerCs" -Value ""
        Write-Host "FAIL - Task '$TaskName' failed to schedule."
    }
}
catch {
    Write-Host "FAIL - Error creating scheduled task: $_"
    return
}
