/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifierExt;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllowFirstThumbprintVerifier
implements ThumbprintVerifierExt {
    private static final Log _logger = LogFactory.getLog(AllowFirstThumbprintVerifier.class);
    private volatile String _thumbprint = null;
    private final String _digestAlgorithm;

    public AllowFirstThumbprintVerifier() {
        this("SHA-256");
    }

    public AllowFirstThumbprintVerifier(String digestAlgorithm) {
        this._digestAlgorithm = digestAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThumbprintVerifier.Result verify(String thumbprint) {
        if (thumbprint == null) {
            return ThumbprintVerifier.Result.MISMATCH;
        }
        if (this._thumbprint == null) {
            AllowFirstThumbprintVerifier allowFirstThumbprintVerifier = this;
            synchronized (allowFirstThumbprintVerifier) {
                if (this._thumbprint == null) {
                    this._thumbprint = thumbprint;
                }
            }
        }
        if (thumbprint.equals(this._thumbprint)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Accepting connection with thumbprint " + thumbprint));
            }
            return ThumbprintVerifier.Result.MATCH;
        }
        if (_logger.isWarnEnabled()) {
            _logger.warn((Object)("Mismatched thumbprint " + thumbprint + ", rejecting connection"));
        }
        return ThumbprintVerifier.Result.MISMATCH;
    }

    @Override
    public void onSuccess(X509Certificate[] chain, String thumbprint, ThumbprintVerifier.Result verifyResult, boolean trustedChain, boolean verifiedAssertion) {
    }

    public String getThumbprint() {
        return this._thumbprint;
    }

    @Override
    public String getDigestAlgorithm() {
        return this._digestAlgorithm;
    }
}

