/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.http.impl;

import com.vmware.vim.vmomi.client.exception.ClientException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.exception.VlsiCertificateException;
import com.vmware.vim.vmomi.client.exception.VmomiProtocolException;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;
import com.vmware.vim.vmomi.core.exception.DuplicateLinkKeyException;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.exception.LinkNotFoundException;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.exception.MessageSignException;
import com.vmware.vim.vmomi.core.exception.UnexpectedTypeException;
import com.vmware.vim.vmomi.core.exception.UnmarshallException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.SSLException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;

public class ClientExceptionTranslator {
    public static Exception translate(Exception e) {
        return ClientExceptionTranslator.translate(e, null);
    }

    public static Exception translate(Exception e, String uri) {
        if (e.getClass().equals(InternalException.class)) {
            com.vmware.vim.vmomi.client.exception.InternalException clientInternalException = new com.vmware.vim.vmomi.client.exception.InternalException(e.getCause());
            clientInternalException.setStackTrace(e.getStackTrace());
            return clientInternalException;
        }
        if (e instanceof SSLException) {
            if (e.getCause() != null && e.getCause().getCause() instanceof VlsiCertificateException) {
                VlsiCertificateException cause = (VlsiCertificateException)e.getCause().getCause();
                return ClientExceptionTranslator.fixStackTrace(new SslException((Throwable)new CertificateValidationException(cause.getMessage(), cause.getCertificateChain(), cause.getThumbprint(), cause.getIsTrusted(), (Throwable)e)));
            }
            return ClientExceptionTranslator.fixStackTrace(new SslException(e));
        }
        String message = ClientExceptionTranslator.getUriExceptionMessage(e, uri);
        if (e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof ConnectionClosedException || e instanceof InterruptedIOException || e instanceof UnknownHostException) {
            return ClientExceptionTranslator.fixStackTrace(new ConnectionException(message, e));
        }
        if (e instanceof MalformedChunkCodingException || e instanceof HttpException || e instanceof NoHttpResponseException || e instanceof ParseException || e instanceof ClientProtocolException) {
            return ClientExceptionTranslator.fixStackTrace(new TransportProtocolException(message, e));
        }
        if (e instanceof MarshallException || e instanceof UnmarshallException || e instanceof UnexpectedTypeException || e instanceof LinkNotFoundException || e instanceof DuplicateLinkKeyException) {
            return ClientExceptionTranslator.fixStackTrace(new VmomiProtocolException(message, e));
        }
        if (e instanceof RejectedExecutionException || e instanceof MessageSignException) {
            return ClientExceptionTranslator.fixStackTrace(new com.vmware.vim.vmomi.client.exception.InternalException(e));
        }
        return e;
    }

    private static Exception fixStackTrace(Exception e) {
        int framesToPop;
        StackTraceElement[] stackTrace = e.getStackTrace();
        String translatorClassName = stackTrace[0].getClassName();
        for (framesToPop = 1; framesToPop < stackTrace.length && translatorClassName.equals(stackTrace[framesToPop].getClassName()); ++framesToPop) {
        }
        StackTraceElement[] newStackTrace = Arrays.copyOfRange(stackTrace, framesToPop, stackTrace.length);
        e.setStackTrace(newStackTrace);
        return e;
    }

    private static String getUriExceptionMessage(Exception e, String uri) {
        if (uri == null) {
            if (e == null) {
                return null;
            }
            return e.toString();
        }
        return String.format("%s invocation failed with \"%s\"", uri, e);
    }

    public static ClientException translateAny(Exception e) {
        Exception result = ClientExceptionTranslator.translate(e);
        if (result instanceof ClientException) {
            return (ClientException)result;
        }
        return new com.vmware.vim.vmomi.client.exception.InternalException(e);
    }
}

