/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.groups;

import com.vmware.srm.client.impex.configurables.ConfigurableConverter;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupProperties;
import com.vmware.srm.client.impex.configurables.groups.recovery.deviceInfos.RecoveryLocationSettingsConverter;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.replication.ProtectedVm;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;
import com.vmware.vim.binding.dr.storageProvider.GroupProtectionDetails;
import com.vmware.vim.binding.dr.vvolProvider.GroupDetails;
import com.vmware.vim.binding.dr.vvolProvider.VmInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.replication.PROTECTED_VM;
import com.vmware.vim.constants.dr.replication.VM_PROTECTION_GROUP;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgPropertiesConverter
implements ConfigurableConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgPropertiesConverter.class);

    public static void setFromVmodl(IeVmProtectionGroup ieProtectionGroup, ManagedObjectReference vmProtectionGroup, PcResult pcResult) {
        Object[] protectedVms = (ManagedObjectReference[])pcResult.getProperty(vmProtectionGroup, "protectedVm");
        HashSet<String> protectedVmIds = new HashSet<String>();
        ArrayList<IeVmProtectionGroupProperties> pgProperties = ArrayUtils.isEmpty((Object[])protectedVms) ? new ArrayList<IeVmProtectionGroupProperties>() : Arrays.stream(protectedVms).map(protectedVm -> PgPropertiesConverter.buildVmProtectionInfo(protectedVm, protectedVmIds, pcResult)).collect(Collectors.toList());
        ieProtectionGroup.setProtectionProperties(pgProperties);
        ProtectionGroup.ReplicationProviderGroupDetails groupDetails = ieProtectionGroup.isProtectedSiteLocal() ? (ProtectionGroup.ReplicationProviderGroupDetails)pcResult.getProperty(vmProtectionGroup, "providerDetails") : (ProtectionGroup.ReplicationProviderGroupDetails)pcResult.getProperty(vmProtectionGroup, VM_PROTECTION_GROUP.PEER_.PROVIDER_DETAILS);
        pgProperties.addAll(PgPropertiesConverter.addNonProtectedVms(groupDetails, protectedVmIds));
    }

    private static IeVmProtectionGroupProperties buildVmProtectionInfo(ManagedObjectReference protectedVm, Set<String> protectedVms, PcResult pcResult) {
        ProtectedVm.PlaceholderVmInfo info = (ProtectedVm.PlaceholderVmInfo)pcResult.getProperty(protectedVm, "placeholderVmInfo");
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        IeVmProtectionGroupProperties pgProperties = new IeVmProtectionGroupProperties();
        pgProperties.setVmProtected(true);
        if (Objects.nonNull(info.placeholderCreationFault)) {
            LOGGER.warn("Skipping protection info for VM: '{}', cause: '{}'.", (Object)protectedVm, (Object)info.placeholderCreationFault.getLocalizedMessage());
        } else {
            if (Objects.nonNull(info.folder)) {
                pgProperties.setFolder(idBuilder.buildId(info.folder));
            }
            if (Objects.nonNull(info.host)) {
                pgProperties.setHost(idBuilder.buildId(info.host));
            }
            if (Objects.nonNull(info.resourcePool)) {
                pgProperties.setResourceGroup(idBuilder.buildId(info.resourcePool));
            }
        }
        ProtectedVm.RecoveryLocationSettings recoverySettings = (ProtectedVm.RecoveryLocationSettings)pcResult.getProperty(protectedVm, "recoveryLocationSettings");
        pgProperties.setRecoverySettings(RecoveryLocationSettingsConverter.fromVmodl(recoverySettings));
        ManagedObjectReference vmMoRef = (ManagedObjectReference)pcResult.getProperty(protectedVm, PROTECTED_VM.VM_INFO_.VM);
        String id = idBuilder.buildId(vmMoRef);
        pgProperties.setId(id);
        protectedVms.add(id);
        return pgProperties;
    }

    private static List<IeVmProtectionGroupProperties> addNonProtectedVms(ProtectionGroup.ReplicationProviderGroupDetails groupDetails, Set<String> protectedVms) {
        if (groupDetails instanceof GroupProtectionDetails) {
            ManagedObjectReference[] unprotectedVms = ((GroupProtectionDetails)groupDetails).vm;
            return PgPropertiesConverter.buildNonProtectedVms(protectedVms, unprotectedVms);
        }
        if (groupDetails instanceof GroupDetails) {
            Object[] unprotectedVms = ((GroupDetails)groupDetails).getUnprotectedVms();
            if (ArrayUtils.isEmpty((Object[])unprotectedVms)) {
                return Collections.emptyList();
            }
            return PgPropertiesConverter.buildNonProtectedVms(protectedVms, (ManagedObjectReference[])Arrays.stream(unprotectedVms).map(VmInfo::getKey).toArray(ManagedObjectReference[]::new));
        }
        return Collections.emptyList();
    }

    private static List<IeVmProtectionGroupProperties> buildNonProtectedVms(Set<String> protectedVms, ManagedObjectReference[] unprotectedVmKeys) {
        if (unprotectedVmKeys == null) {
            return Collections.emptyList();
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return Arrays.stream(unprotectedVmKeys).map(idBuilder::buildId).filter(id -> !protectedVms.contains(id)).map(IeVmProtectionGroupProperties::new).collect(Collectors.toList());
    }
}

