/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.configurables.plans;

import com.vmware.srm.client.impex.configurables.common.CalloutConverter;
import com.vmware.srm.client.impex.configurables.plans.IeCalloutSpec;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.vim.binding.dr.recovery.Callout;
import com.vmware.vim.binding.dr.recovery.CalloutSpec;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalloutSpecConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalloutSpecConverter.class);

    public static List<IeCalloutSpec> fromVmodl(CalloutSpec[] calloutSpecs) {
        if (ArrayUtils.isEmpty((Object[])calloutSpecs)) {
            return Collections.emptyList();
        }
        return Arrays.stream(calloutSpecs).map(calloutSpec -> new IeCalloutSpec(calloutSpec.position.name(), CalloutConverter.fromVmodl(calloutSpec.callouts))).collect(Collectors.toList());
    }

    public static CalloutSpec toVmodl(IeCalloutSpec ieCalloutSpec, String planName) {
        Callout[] callouts = CalloutConverter.toVmodl(ieCalloutSpec.getCallouts());
        RecoveryPlan.Position position = CalloutSpecConverter.convertPosition(ieCalloutSpec.getPosition(), planName);
        return new CalloutSpec(position, callouts);
    }

    private static RecoveryPlan.Position convertPosition(String iePosition, String planName) {
        switch (iePosition) {
            case "atBegin": {
                return RecoveryPlan.Position.atBegin;
            }
            case "beforeDiscoverRuMetadataSync": {
                return RecoveryPlan.Position.beforeDiscoverRuMetadataSync;
            }
            case "beforeSyncMetadata": {
                return RecoveryPlan.Position.beforeSyncMetadata;
            }
            case "beforePresyncStorage": {
                return RecoveryPlan.Position.beforePresyncStorage;
            }
            case "beforeRestoringHostsForMigration": {
                return RecoveryPlan.Position.beforeRestoringHostsForMigration;
            }
            case "beforeSuspendRecoverySiteVmsForMigration": {
                return RecoveryPlan.Position.beforeSuspendRecoverySiteVmsForMigration;
            }
            case "beforePrepareStorageForVMotion": {
                return RecoveryPlan.Position.beforePrepareStorageForVMotion;
            }
            case "beforeVMotionVms": {
                return RecoveryPlan.Position.beforeVMotionVms;
            }
            case "beforeDisableProtectedSiteVms": {
                return RecoveryPlan.Position.beforeDisableProtectedSiteVms;
            }
            case "beforeShutdownProtectedSiteVms": {
                return RecoveryPlan.Position.beforeShutdownProtectedSiteVms;
            }
            case "beforeResumeProtectedSiteVms": {
                return RecoveryPlan.Position.beforeResumeProtectedSiteVms;
            }
            case "beforePowerOffRecoverySiteVms": {
                return RecoveryPlan.Position.beforePowerOffRecoverySiteVms;
            }
            case "beforeResumeRecoverySiteVms": {
                return RecoveryPlan.Position.beforeResumeRecoverySiteVms;
            }
            case "beforeDeactivateRecoveryUnits": {
                return RecoveryPlan.Position.beforeDeactivateRecoveryUnits;
            }
            case "beforePostProcessAfterDeactivate": {
                return RecoveryPlan.Position.beforePostProcessAfterDeactivate;
            }
            case "beforeDeactivateConsistencyGroups": {
                return RecoveryPlan.Position.beforeDeactivateConsistencyGroups;
            }
            case "beforeBeginPreparePrimarySiteHosts": {
                return RecoveryPlan.Position.beforeBeginPreparePrimarySiteHosts;
            }
            case "beforeBeginPrepareStorage": {
                return RecoveryPlan.Position.beforeBeginPrepareStorage;
            }
            case "beforeSyncStorage": {
                return RecoveryPlan.Position.beforeSyncStorage;
            }
            case "beforeRestoreHosts": {
                return RecoveryPlan.Position.beforeRestoreHosts;
            }
            case "beforePrepareStorage": {
                return RecoveryPlan.Position.beforePrepareStorage;
            }
            case "beforeRestoreStorage": {
                return RecoveryPlan.Position.beforeRestoreStorage;
            }
            case "beforeDiscoverPiggybackUnits": {
                return RecoveryPlan.Position.beforeDiscoverPiggybackUnits;
            }
            case "beforeCleanupRecoveryUnits": {
                return RecoveryPlan.Position.beforeCleanupRecoveryUnits;
            }
            case "beforeCleanupConsistencyGroups": {
                return RecoveryPlan.Position.beforeCleanupConsistencyGroups;
            }
            case "beforeSuspendRecoverySiteVms": {
                return RecoveryPlan.Position.beforeSuspendRecoverySiteVms;
            }
            case "beforeSuspendProtectedSiteVms": {
                return RecoveryPlan.Position.beforeSuspendProtectedSiteVms;
            }
            case "beforeConfigureStorage": {
                return RecoveryPlan.Position.beforeConfigureStorage;
            }
            case "beforeImportVms": {
                return RecoveryPlan.Position.beforeImportVms;
            }
            case "beforeApplyingPolicies": {
                return RecoveryPlan.Position.beforeApplyingPolicies;
            }
            case "beforeRecoverPriority1Vms": {
                return RecoveryPlan.Position.beforeRecoverPriority1Vms;
            }
            case "beforeRecoverPriority2Vms": {
                return RecoveryPlan.Position.beforeRecoverPriority2Vms;
            }
            case "beforeRecoverPriority3Vms": {
                return RecoveryPlan.Position.beforeRecoverPriority3Vms;
            }
            case "beforeRecoverPriority4Vms": {
                return RecoveryPlan.Position.beforeRecoverPriority4Vms;
            }
            case "beforeRecoverPriority5Vms": {
                return RecoveryPlan.Position.beforeRecoverPriority5Vms;
            }
            case "beforeCreatePlaceholderVms": {
                return RecoveryPlan.Position.beforeCreatePlaceholderVms;
            }
            case "beforeFinalizeStorage": {
                return RecoveryPlan.Position.beforeFinalizeStorage;
            }
            case "beforeReverseReplication": {
                return RecoveryPlan.Position.beforeReverseReplication;
            }
            case "atEnd": {
                return RecoveryPlan.Position.atEnd;
            }
        }
        String message = ImpexL10N.localize("plan.callouts", iePosition, planName);
        LOGGER.warn(message);
        ImpexImportSrmContext.get().addError(message);
        return RecoveryPlan.Position.atBegin;
    }
}

