/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.folders;

import com.vmware.srm.client.impex.configurables.Configurable;
import com.vmware.srm.client.impex.configurables.folders.IeFolder;
import com.vmware.srm.client.impex.configurables.plans.IeRecoveryPlan;
import com.vmware.srm.client.impex.exporters.Exporter;
import com.vmware.srm.client.impex.exporters.plans.RecoveryPlansExporter;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.PlanUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryPlanFoldersExporter
extends Exporter<IeFolder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecoveryPlanFoldersExporter.class);

    @Override
    public Promise<List<IeFolder>> getConfigurables() {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        String guid = ((SrmServer)serversData.getLocalPair().server()).guid();
        ManagedObjectReference root = ClientUtils.createMoRef((String)"DrFolder", (String)"DrRecoveryRootFolder", (String)guid);
        return PlanUtil.getRecoveryPlans((ServersView)serversData.getView(), PlanUtil.getRootFolder(guid), RecoveryPlansExporter.getPropertySpec()).thenApply(pcResult -> {
            IeFolder ieRoot = new IeFolder();
            String name = (String)pcResult.getProperty(root, "name");
            ieRoot.setName(name);
            List<Configurable> children = this.getChildren(new RecoveryPlansExporter((PcResult)pcResult), root, (PcResult)pcResult);
            ieRoot.setChildren(children);
            return Collections.singletonList(ieRoot);
        });
    }

    private List<Configurable> getChildren(RecoveryPlansExporter exporter, ManagedObjectReference parent, PcResult pcResult) {
        ArrayList<Configurable> srmChildren = new ArrayList<Configurable>();
        ManagedObjectReference[] children = (ManagedObjectReference[])pcResult.getProperty(parent, "childEntity");
        Arrays.stream(children).forEach(child -> {
            String type = child.getType();
            if ("DrFolder".equals(type)) {
                String name = (String)pcResult.getProperty(child, "name");
                IeFolder ieFolder = new IeFolder();
                ieFolder.setName(name);
                ieFolder.setChildren(this.getChildren(exporter, (ManagedObjectReference)child, pcResult));
                srmChildren.add(ieFolder);
            } else if ("DrRecoveryRecoveryPlan".equals(type)) {
                IeRecoveryPlan recoveryPlan = exporter.convertToIeRecoveryPlan((ManagedObjectReference)child);
                srmChildren.add(recoveryPlan);
            } else {
                LOGGER.error("Parent '{}' has child: '{}' with unexpected type.", (Object)parent, child);
            }
        });
        return srmChildren;
    }
}

