/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.groups;

import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.replication.ProtectionGroup;
import com.vmware.vim.binding.dr.storage.ArrayInfo;
import com.vmware.vim.binding.dr.storage.ReplicatedArrayPair;
import com.vmware.vim.binding.dr.storageProvider.DatastoreRecoverySpec;
import com.vmware.vim.binding.dr.storageProvider.GroupProtectionDetails;
import com.vmware.vim.binding.dr.storageProvider.GroupRecoveryDetails;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StorageProviderSettingsExporter {
    private final PcResult _pcResult;

    public StorageProviderSettingsExporter(PcResult pcResult) {
        this._pcResult = pcResult;
    }

    public void convertProviderSettings(IeVmProtectionGroup ieProtectionGroup, ManagedObjectReference vmProtectionGroup) {
        ieProtectionGroup.setProviderType(IeVmProtectionGroup.IeProviderType.Abr);
        ProtectionGroup.ReplicationProviderGroupDetails details = (ProtectionGroup.ReplicationProviderGroupDetails)this._pcResult.getProperty(vmProtectionGroup, "providerDetails");
        if (details == null) {
            return;
        }
        if (details instanceof GroupProtectionDetails) {
            this.convertProtectionDetails((GroupProtectionDetails)details, ieProtectionGroup);
            return;
        }
        if (details instanceof GroupRecoveryDetails) {
            this.convertRecoveryDetails((GroupRecoveryDetails)details, ieProtectionGroup);
            return;
        }
        throw new IllegalStateException("ProtectionGroupProviderDetails not null && not GPD && not GRD.");
    }

    private void convertProtectionDetails(GroupProtectionDetails details, IeVmProtectionGroup ieProtectionGroup) {
        ManagedObjectReference[] datastores = details.datastore;
        if (datastores == null) {
            return;
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        List<String> datastoreIds = Arrays.stream(datastores).map(idBuilder::buildId).collect(Collectors.toList());
        ieProtectionGroup.setDatastores(datastoreIds);
        ManagedObjectReference apRef = details.array;
        ArrayInfo arrayInfo = (ArrayInfo)this._pcResult.getProperty(apRef, "info");
        if (arrayInfo == null) {
            return;
        }
        ieProtectionGroup.setArrayPairKey(arrayInfo.getKey());
    }

    private void convertRecoveryDetails(GroupRecoveryDetails details, IeVmProtectionGroup ieProtectionGroup) {
        DatastoreRecoverySpec[] specs = details.datastore;
        if (specs == null) {
            return;
        }
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        List<String> datastoreIds = Arrays.stream(specs).map(DatastoreRecoverySpec::getProtectedDatastore).filter(Objects::nonNull).flatMap(Arrays::stream).map(idBuilder::buildId).collect(Collectors.toList());
        ieProtectionGroup.setDatastores(datastoreIds);
        ManagedObjectReference apRef = details.array;
        ReplicatedArrayPair.Peer peer = (ReplicatedArrayPair.Peer)this._pcResult.getProperty(apRef, "peer");
        if (peer == null) {
            return;
        }
        ieProtectionGroup.setArrayPairKey(peer.getArrayId());
    }
}

