/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.groups;

import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.PgPropertiesConverter;
import com.vmware.srm.client.impex.exporters.groups.HbrProviderSettingsExporter;
import com.vmware.srm.client.impex.exporters.groups.ProtectionGroupsExporter;
import com.vmware.srm.client.impex.exporters.groups.StorageProviderSettingsExporter;
import com.vmware.srm.client.impex.exporters.groups.VvolProviderSettingsExporter;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmProtectionGroupsExporter
extends ProtectionGroupsExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmProtectionGroupsExporter.class);
    private final StorageProviderSettingsExporter _storageProviderExporter;
    private final HbrProviderSettingsExporter _hbrProviderExporter;
    private final VvolProviderSettingsExporter _vvolProviderExporter;

    public VmProtectionGroupsExporter(PcResult pcResult, DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
        super(pcResult);
        this._storageProviderExporter = new StorageProviderSettingsExporter(pcResult);
        this._hbrProviderExporter = new HbrProviderSettingsExporter();
        this._vvolProviderExporter = new VvolProviderSettingsExporter(pcResult, localDomainInfos, remoteDomainInfos);
    }

    public IeVmProtectionGroup convertProtectionGroup(ManagedObjectReference protectionGroupMoRef) {
        IeVmProtectionGroup ieProtectionGroup = new IeVmProtectionGroup();
        this.setBasicSettings(protectionGroupMoRef, ieProtectionGroup);
        this.convertVmPg(protectionGroupMoRef, ieProtectionGroup);
        PgPropertiesConverter.setFromVmodl(ieProtectionGroup, protectionGroupMoRef, this._pcResult);
        return ieProtectionGroup;
    }

    private void convertVmPg(ManagedObjectReference vmProtectionGroup, IeVmProtectionGroup ieProtectionGroup) {
        ManagedObjectReference providerMoRef = (ManagedObjectReference)this._pcResult.getProperty(vmProtectionGroup, "provider");
        String type = providerMoRef.getType();
        if ("DrReplicationStorageProvider".equals(type)) {
            this._storageProviderExporter.convertProviderSettings(ieProtectionGroup, vmProtectionGroup);
        } else if ("DrReplicationHbrProvider".equals(type)) {
            this._hbrProviderExporter.convertProviderSettings(ieProtectionGroup);
        } else if ("DrReplicationVvolProvider".equals(type)) {
            this._vvolProviderExporter.convertProviderSettings(ieProtectionGroup, vmProtectionGroup);
        } else {
            LOGGER.warn("Unexpected VMPG provider type, provider: {}", (Object)providerMoRef);
        }
    }
}

