/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.groups;

import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupFaultDomain;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupReplicationGroup;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.vvolProvider.DomainInfo;
import com.vmware.vim.binding.dr.vvolProvider.GroupDetails;
import com.vmware.vim.binding.vim.vm.replication.FaultDomainId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.constants.dr.replication.VM_PROTECTION_GROUP;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VvolProviderSettingsExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(VvolProviderSettingsExporter.class);
    private final PcResult _pcResult;
    private final DomainInfo[] _localDomainInfos;
    private final DomainInfo[] _remoteDomainInfos;

    public VvolProviderSettingsExporter(PcResult pcResult, DomainInfo[] localDomainInfos, DomainInfo[] remoteDomainInfos) {
        this._pcResult = pcResult;
        this._localDomainInfos = localDomainInfos;
        this._remoteDomainInfos = remoteDomainInfos;
    }

    public void convertProviderSettings(IeVmProtectionGroup ieProtectionGroup, ManagedObjectReference vvolProtectionGroup) {
        ieProtectionGroup.setProviderType(IeVmProtectionGroup.IeProviderType.Vvol);
        GroupDetails vvolDetails = (GroupDetails)this._pcResult.getProperty(vvolProtectionGroup, ieProtectionGroup.isProtectedSiteLocal() ? "providerDetails" : VM_PROTECTION_GROUP.PEER_.PROVIDER_DETAILS);
        this.convertFaultDomain(ieProtectionGroup, vvolDetails);
    }

    private void convertFaultDomain(IeVmProtectionGroup ieProtectionGroup, GroupDetails vvolDetails) {
        List<IeVmProtectionGroupReplicationGroup> replicationGroups;
        String domainInfoName;
        String domainInfoId;
        FaultDomainId pgFaultDomain = vvolDetails.getDomain();
        if (pgFaultDomain == null) {
            domainInfoId = null;
            domainInfoName = null;
            LOGGER.error("vVol protection group '{}' has no fault domain.", (Object)ieProtectionGroup.getName());
        } else {
            domainInfoId = pgFaultDomain.id;
            domainInfoName = Arrays.stream(ieProtectionGroup.isProtectedSiteLocal() ? this._localDomainInfos : this._remoteDomainInfos).filter(info -> domainInfoId.equals(info.id.id)).map(DomainInfo::getName).findFirst().orElseGet(() -> {
                LOGGER.error("vVol protection group '{}' fault domain with id: '{}' cannot be found.", (Object)ieProtectionGroup.getName(), (Object)faultDomainId.id);
                return null;
            });
        }
        Object[] pgReplicationGroups = vvolDetails.getReplicationGroups();
        if (ArrayUtils.isEmpty((Object[])pgReplicationGroups)) {
            replicationGroups = null;
            LOGGER.warn("No replication groups for vVol protection group: '{}'.", (Object)ieProtectionGroup.getName());
        } else {
            replicationGroups = Arrays.stream(pgReplicationGroups).map(replicationGroup -> new IeVmProtectionGroupReplicationGroup(replicationGroup.replicationGroup.deviceGroupId.id, replicationGroup.name)).collect(Collectors.toList());
        }
        ieProtectionGroup.setFaultDomain(new IeVmProtectionGroupFaultDomain(domainInfoId, domainInfoName, replicationGroups));
    }
}

