/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.inventory;

import com.vmware.srm.client.impex.configurables.inventory.IeInventoryTree;
import com.vmware.srm.client.impex.configurables.inventory.InventoryConverter;
import com.vmware.srm.client.impex.exporters.SingleSiteExporter;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.Collections;
import java.util.List;

public abstract class InventoryExporter
extends SingleSiteExporter<IeInventoryTree> {
    @Override
    protected Promise<List<IeInventoryTree>> getSingleSiteConfigurables(boolean local) {
        SrmServersDataWrapper serversData = this.getServersDataWrapper();
        String vcGuid = local ? ((SrmServer)serversData.getLocalPair().server()).vc().guid() : ((SrmServer)serversData.getRemotePair().server()).vc().guid();
        return PCUtil.retrieveProperties((ServersView)serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{InventoryConverter.getFilterSpec(vcGuid)}).thenApply(pcResult -> {
            IeInventoryTree tree = new IeInventoryTree();
            tree.setLocal(local);
            tree.setRoot(InventoryConverter.rootFromVmodl(this.getIdBuilder(), pcResult, vcGuid));
            return Collections.singletonList(tree);
        });
    }

    protected abstract SrmServersDataWrapper getServersDataWrapper();

    protected abstract IdBuilder getIdBuilder();
}

