/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.plans;

import com.vmware.srm.client.impex.configurables.mappings.RecoveryTestNetworkMappingConverter;
import com.vmware.srm.client.impex.configurables.plans.CalloutSpecConverter;
import com.vmware.srm.client.impex.configurables.plans.IeCalloutSpec;
import com.vmware.srm.client.impex.configurables.plans.IeRecoveryPlan;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.utils.PlanUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.vim.binding.dr.recovery.CalloutSpec;
import com.vmware.vim.binding.dr.recovery.RecoveryPlan;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.dr.recovery.RECOVERY_PLAN;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RecoveryPlansExporter {
    private final PcResult _pcResult;

    public static PropertyCollector.PropertySpec getPropertySpec() {
        return PCUtil.createPropertySpec((String)"DrRecoveryRecoveryPlan", (String[])new String[]{"info", "calloutSpecs", RECOVERY_PLAN.LOCAL_SETTINGS_.SUSPEND_VMS, RECOVERY_PLAN.LOCAL_SETTINGS_.PROTECTION_GROUPS, RECOVERY_PLAN.LOCAL_SETTINGS_.TEST_NETWORK_MAPPINGS, RECOVERY_PLAN.REMOTE_SETTINGS_.SUSPEND_VMS, RECOVERY_PLAN.REMOTE_SETTINGS_.PROTECTION_GROUPS, RECOVERY_PLAN.REMOTE_SETTINGS_.TEST_NETWORK_MAPPINGS});
    }

    public RecoveryPlansExporter(PcResult pcResult) {
        this._pcResult = pcResult;
    }

    public IeRecoveryPlan convertToIeRecoveryPlan(ManagedObjectReference recoveryPlan) {
        RecoveryPlan.Info info = (RecoveryPlan.Info)this._pcResult.getProperty(recoveryPlan, "info");
        IeRecoveryPlan ieRecoveryPlan = new IeRecoveryPlan(info);
        ieRecoveryPlan.setProtectionGroups(this.convertPgIDs(recoveryPlan));
        ieRecoveryPlan.setRecoverySiteLocal(PlanUtil.isRecoverySiteLocal(info.getStateInfo().getState()));
        ieRecoveryPlan.setNetworks(RecoveryTestNetworkMappingConverter.fromVmodl(recoveryPlan, ieRecoveryPlan, this._pcResult));
        ieRecoveryPlan.setCalloutSpecs(this.convertCallouts(recoveryPlan));
        ieRecoveryPlan.setKeyedVms(this.convertKeyedVms(recoveryPlan, ieRecoveryPlan.isRecoverySiteLocal()));
        return ieRecoveryPlan;
    }

    private List<String> convertPgIDs(ManagedObjectReference recoveryPlan) {
        ManagedObjectReference[] protectionGroups = (ManagedObjectReference[])this._pcResult.getProperty(recoveryPlan, RECOVERY_PLAN.LOCAL_SETTINGS_.PROTECTION_GROUPS);
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return Arrays.stream(protectionGroups).map(idBuilder::buildId).collect(Collectors.toList());
    }

    private List<IeCalloutSpec> convertCallouts(ManagedObjectReference recoveryPlan) {
        CalloutSpec[] calloutSpecs = (CalloutSpec[])this._pcResult.getProperty(recoveryPlan, "calloutSpecs");
        return CalloutSpecConverter.fromVmodl(calloutSpecs);
    }

    private List<String> convertKeyedVms(ManagedObjectReference recoveryPlan, boolean recoverySiteLocal) {
        RecoveryPlan.KeyedVm[] keyedVms = (RecoveryPlan.KeyedVm[])this._pcResult.getProperty(recoveryPlan, recoverySiteLocal ? RECOVERY_PLAN.LOCAL_SETTINGS_.SUSPEND_VMS : RECOVERY_PLAN.REMOTE_SETTINGS_.SUSPEND_VMS);
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        return Arrays.stream(keyedVms).map(RecoveryPlan.KeyedVm::getVm).map(idBuilder::buildId).collect(Collectors.toList());
    }
}

