/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.exporters.vmSettings;

import com.vmware.srm.client.impex.configurables.vmSettings.IeVmSettings;
import com.vmware.srm.client.impex.configurables.vmSettings.VmSettingsConverter;
import com.vmware.srm.client.impex.exporters.SingleSiteExporter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.IdBuilder;
import com.vmware.srm.client.impex.tool.ImpexExportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.infrastructure.pc.utils.ObjectSpecBuilder;
import com.vmware.srm.client.infrastructure.pc.utils.PCUtil;
import com.vmware.srm.client.infrastructure.pc.utils.PcResult;
import com.vmware.srm.client.infrastructure.tuple.Tuple2;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.srm.client.topology.impl.vmomi.ClientUtils;
import com.vmware.vim.binding.dr.recovery.RecoverySettingsRepository;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.constants.vim.VIRTUAL_MACHINE;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmSettingsExporter
extends SingleSiteExporter<IeVmSettings> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmSettingsExporter.class);

    @Override
    protected Promise<List<IeVmSettings>> getSingleSiteConfigurables(boolean local) {
        return this.getVmSettingMapping(local).thenCombine(this.buildLocalVmKeys(local), (vmSettingMappings, localVmKeys) -> {
            if (vmSettingMappings == null) {
                return Collections.emptyList();
            }
            List<RecoverySettingsRepository.VmSettingsMapping> localVmSettingsMappings = Arrays.stream(vmSettingMappings).filter(vmSettingsMapping -> localVmKeys.containsKey(vmSettingsMapping.key)).collect(Collectors.toList());
            return VmSettingsConverter.fromVmodl(localVmSettingsMappings, localVmKeys);
        });
    }

    private Promise<RecoverySettingsRepository.VmSettingsMapping[]> getVmSettingMapping(boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        SrmService srmService = local ? (SrmService)((SrmServer)serversData.getLocalPair().server()).service() : (SrmService)((SrmServer)serversData.getRemotePair().server()).service();
        ManagedObjectReference recoverySettingsRepository = local ? serversData.getLocalContent().recoverySettingsRepository : serversData.getRemoteContent().recoverySettingsRepository;
        RecoverySettingsRepository repository = (RecoverySettingsRepository)srmService.createStub(recoverySettingsRepository);
        FuturePromise vmSettingMappingsFP = new FuturePromise();
        repository.getRecoverySettings((Future)vmSettingMappingsFP);
        return vmSettingMappingsFP.onError(error -> LOGGER.warn("Could not get vm setting mappings, guid: {}.", (Object)repository._getRef().getServerGuid(), error));
    }

    private Promise<InventoryExtractor.VmKeysLookup> buildLocalVmKeys(boolean local) {
        SrmServersDataWrapper serversData = ImpexExportSrmContext.getServersDataWrapper();
        SrmServer srmServer = local ? (SrmServer)serversData.getLocalPair().server() : (SrmServer)serversData.getRemotePair().server();
        return PCUtil.retrieveProperties((ServersView)serversData.getView(), (PropertyCollector.FilterSpec[])new PropertyCollector.FilterSpec[]{VmSettingsExporter.getFilterSpec(srmServer.vc().guid())}).thenApply(VmSettingsExporter::processPcResult);
    }

    private static InventoryExtractor.VmKeysLookup processPcResult(PcResult pcResult) {
        IdBuilder idBuilder = ImpexExportSrmContext.getIdBuilder();
        Map<String, String> vmIdToKey = pcResult.getMoRefs().stream().filter(moRef -> "VirtualMachine".equals(moRef.getType())).map(moRef -> new Tuple2(pcResult.tryGetProperty(moRef, VIRTUAL_MACHINE.CONFIG_.INSTANCE_UUID, error -> {
            LOGGER.warn("Unable to retrieve VM instance UUID for VM: {} .", moRef);
            return null;
        }), moRef)).filter(vmTuple -> {
            if (vmTuple.getFirst() == null) {
                LOGGER.warn("Skipping null VM instance UUID for VM: {} .", vmTuple.getSecond());
                return false;
            }
            if (((String)vmTuple.getFirst()).isEmpty()) {
                LOGGER.warn("Skipping empty VM instance UUID for VM: {} .", vmTuple.getSecond());
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Tuple2::getFirst, vmTuple -> idBuilder.buildId((ManagedObjectReference)vmTuple.getSecond())));
        return new InventoryExtractor.VmKeysLookup(vmIdToKey);
    }

    private static PropertyCollector.FilterSpec getFilterSpec(String vcGuid) {
        PropertyCollector.PropertySpec vmPropertySpec = PCUtil.createPropertySpec((String)"VirtualMachine", (String[])new String[]{"name", VIRTUAL_MACHINE.CONFIG_.INSTANCE_UUID});
        ManagedObjectReference rootFolder = ClientUtils.createMoRef((String)"Folder", (String)"group-d1", (String)vcGuid);
        ObjectSpecBuilder specBuilder = new ObjectSpecBuilder(rootFolder);
        ObjectSpecBuilder.TraversalSpecBuilder rootTraversal = specBuilder.traverseTo("childEntity");
        ObjectSpecBuilder.TraversalSpecBuilder dcTraversal = rootTraversal.traverseTo("Datacenter", "vmFolder");
        ObjectSpecBuilder.TraversalSpecBuilder computeResourceTraversal = rootTraversal.traverseTo("Datacenter", "hostFolder");
        ObjectSpecBuilder.TraversalSpecBuilder hostSystemTraversal = rootTraversal.traverseTo("ComputeResource", "host");
        ObjectSpecBuilder.TraversalSpecBuilder computeResourcePoolTraversal = rootTraversal.traverseTo("ComputeResource", "resourcePool");
        ObjectSpecBuilder.TraversalSpecBuilder resourcePoolPoolTraversal = computeResourcePoolTraversal.traverseTo("ResourcePool", "resourcePool");
        resourcePoolPoolTraversal.traverseTo("ResourcePool", "vm");
        rootTraversal.loopTo(rootTraversal.getName());
        rootTraversal.loopTo(dcTraversal.getName());
        rootTraversal.loopTo(computeResourceTraversal.getName());
        rootTraversal.loopTo(computeResourcePoolTraversal.getName());
        rootTraversal.loopTo(resourcePoolPoolTraversal.getName());
        dcTraversal.loopTo(rootTraversal.getName());
        computeResourceTraversal.loopTo(rootTraversal.getName());
        computeResourcePoolTraversal.loopTo(rootTraversal.getName());
        hostSystemTraversal.loopTo(rootTraversal.getName());
        computeResourcePoolTraversal.loopTo(computeResourcePoolTraversal.getName());
        resourcePoolPoolTraversal.loopTo(resourcePoolPoolTraversal.getName());
        return new PropertyCollector.FilterSpec(new PropertyCollector.PropertySpec[]{vmPropertySpec}, new PropertyCollector.ObjectSpec[]{specBuilder.build()}, Boolean.valueOf(true));
    }
}

