/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.advancedSettings;

import com.vmware.srm.client.impex.configurables.advancedSettings.AdvancedSettingsConverter;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteAdvancedSettingsImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiteAdvancedSettingsImporter.class);

    public Promise<Void> create() {
        return this.updateSettings(true).thenCombine(this.updateSettings(false), (aVoid1, aVoid2) -> null);
    }

    private Promise<Void> updateSettings(boolean local) {
        Object[] optionValues = AdvancedSettingsConverter.toVmodl(local);
        SrmServersDataWrapper serversData = ImpexImportSrmContext.get().getServersDataWrapper();
        SrmServer srmServer = local ? (SrmServer)serversData.getLocalPair().server() : (SrmServer)serversData.getRemotePair().server();
        String guid = srmServer.guid();
        if (ArrayUtils.isEmpty((Object[])optionValues)) {
            LOGGER.info("No advanced settings to import for server with guid '{}'.", (Object)guid);
            return Promises.resolve(null);
        }
        ManagedObjectReference optionManagerRef = local ? serversData.getLocalContent().optionManager : serversData.getRemoteContent().optionManager;
        OptionManager optManager = (OptionManager)((SrmService)srmServer.service()).createStub(optionManagerRef);
        LOGGER.info("Started advanced settings import for server with guid '{}'.", (Object)guid);
        FuturePromise futurePromise = new FuturePromise();
        optManager.updateValues((OptionValue[])optionValues, (Future)futurePromise);
        return futurePromise.onSuccess(aVoid -> LOGGER.info("Successfully imported advanced settings for server with guid '{}'.", (Object)guid)).onError(error -> {
            String message = ImpexL10N.localize("advancedSettings", guid);
            LOGGER.warn(message, (Throwable)error);
            ImpexImportSrmContext.get().addError(message, (Exception)error);
        });
    }
}

