/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.arrayManagers;

import com.vmware.srm.client.impex.configurables.arrayManagers.IeArrayPair;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.tool.SrmServersDataWrapper;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.TaskUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.Publisher;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.reactive.impl.Streams;
import com.vmware.srm.client.topology.client.view.availability.srm.SrmServer;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.storage.ArrayManager;
import com.vmware.vim.binding.dr.storage.ReplicatedArrayPair;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayPairImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayPairImporter.class);

    public Promise<Void> addPair(ManagedObjectReference amMoRef, List<IeArrayPair> ieArrayPairs, String amName) {
        if (ieArrayPairs == null) {
            LOGGER.debug("IeArrayPairs are null for array manager '{}'.", (Object)amName);
            return Promises.resolve(null);
        }
        ArrayManager arrayManager = (ArrayManager)IContextUtil.getSrmService(true).createStub(amMoRef);
        Promise[] results = (Promise[])ieArrayPairs.stream().map(ieArrayPair -> this.doAddPair(arrayManager, (IeArrayPair)ieArrayPair).materialize()).toArray(Promise[]::new);
        return Streams.from((Publisher[])results).collect().thenApply(unused -> null);
    }

    private Promise<Void> doAddPair(ArrayManager arrayManager, IeArrayPair ieArrayPair) {
        String key = ieArrayPair.getKey();
        String pairKey = ieArrayPair.getPairKey();
        SrmServersDataWrapper serversData = ImpexImportSrmContext.get().getServersDataWrapper();
        SrmService service = (SrmService)((SrmServer)serversData.getLocalPair().server()).service();
        FuturePromise addApTaskPromise = new FuturePromise();
        arrayManager.addArrayPair(key, serversData.getLocalPair().pairServerVmomiRef(), pairKey, (Future)addApTaskPromise);
        return addApTaskPromise.thenCompose(addApTaskMoRef -> TaskUtil.monitorTask(service, addApTaskMoRef)).thenCompose(replicatedApMoRef -> this.discoverDevices((ReplicatedArrayPair)service.createStub(replicatedApMoRef), key, pairKey)).thenCompose(discoverDevicesTaskMoRef -> TaskUtil.monitorTask(service, discoverDevicesTaskMoRef)).thenApply(discoverDevicesDone -> null);
    }

    private Promise<ManagedObjectReference> discoverDevices(ReplicatedArrayPair replicatedArrayPair, String key, String pairKey) {
        LOGGER.info("Starting Discovery Devices for array pair with keys '{}' and '{}'.", (Object)key, (Object)pairKey);
        FuturePromise discoverDevicesTaskPromise = new FuturePromise();
        replicatedArrayPair.discoverDevices(false, (Future)discoverDevicesTaskPromise);
        return discoverDevicesTaskPromise.onSuccess(done -> LOGGER.info("Discovery Devices done for array pair with keys '{}' and '{}'.", (Object)key, (Object)pairKey)).onError(error -> LOGGER.warn("Discovery Devices failed for array pair with keys '{}' and '{}'.", new Object[]{key, pairKey, error}));
    }
}

