/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.groups.sp;

import com.vmware.srm.client.impex.configurables.groups.IeSpProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.SpPgSettingsConverter;
import com.vmware.srm.client.impex.importers.folders.groups.GroupImporter;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.GroupUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.vim.binding.dr.replication.StorageProfileProtectionGroup;
import com.vmware.vim.binding.pbm.profile.Profile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpGroupImporter
extends GroupImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpGroupImporter.class);
    private final Profile[] _localProfiles;
    private final Profile[] _remoteProfiles;

    public SpGroupImporter(Profile[] localProfiles, Profile[] remoteProfiles) {
        this._localProfiles = localProfiles;
        this._remoteProfiles = remoteProfiles;
    }

    public Promise<ManagedObjectReference> createSpProtectionGroup(IeSpProtectionGroup ieSpPg, ManagedObjectReference parent) {
        if (ieSpPg == null || parent == null) {
            return Promises.reject((Exception)new IllegalArgumentException());
        }
        LOGGER.info("Starting ProtectionGroup '{}' creating.", (Object)ieSpPg.getName());
        return GroupUtil.getProviders(true).thenCombineCompose(GroupUtil.getProviders(false), (localProviders, remoteProviders) -> {
            StorageProfileProtectionGroup.Settings settings;
            boolean local = ieSpPg.isProtectedSiteLocal();
            StorageProfileProtectionGroup.Settings settings2 = settings = local ? SpPgSettingsConverter.toVmodl(ieSpPg, localProviders, this._localProfiles) : SpPgSettingsConverter.toVmodl(ieSpPg, remoteProviders, this._remoteProfiles);
            if (local) {
                return this.createSpPg(true, settings, parent);
            }
            return this.getPeerFolderPromise(parent).thenCompose(peerFolder -> this.createSpPg(false, settings, (ManagedObjectReference)peerFolder));
        });
    }

    private Promise<ManagedObjectReference> createSpPg(boolean local, StorageProfileProtectionGroup.Settings settings, ManagedObjectReference location) {
        ManagedObjectReference remoteSite = local ? ImpexImportSrmContext.get().getServersDataWrapper().getLocalPair().pairServerVmomiRef() : ImpexImportSrmContext.get().getServersDataWrapper().getRemotePair().pairServerVmomiRef();
        FuturePromise taskPromise = new FuturePromise();
        GroupUtil.getReplicationManager(local).createStorageProfileProtectionGroup(location, settings, remoteSite, (Future)taskPromise);
        return taskPromise.thenCompose(taskMoRef -> ImpexImportSrmContext.get().monitor((ManagedObjectReference)taskMoRef));
    }
}

