/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.folders.groups.vm;

import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroup;
import com.vmware.srm.client.impex.configurables.groups.IeVmProtectionGroupProperties;
import com.vmware.srm.client.impex.importers.folders.groups.vm.RecoveryLocationSettingsConverter;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.impex.utils.TaskUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.replication.ProtectedVm;
import com.vmware.vim.binding.dr.replication.VmProtectionGroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmGroupProtector {
    private static final Logger LOGGER = LoggerFactory.getLogger(VmGroupProtector.class);
    private final InventoryExtractor.InventoryLookup _inventory;
    private final RecoveryLocationSettingsConverter _rlsConverter;

    public VmGroupProtector(InventoryExtractor.InventoryLookup inventory, RecoveryLocationSettingsConverter rlsConverter) {
        this._inventory = inventory;
        this._rlsConverter = rlsConverter;
    }

    public Promise<Void> protectVms(IeVmProtectionGroup ieVmPg, ManagedObjectReference protectionGroup) {
        Validate.notNull((Object)ieVmPg);
        Validate.notNull((Object)protectionGroup);
        LOGGER.info("Protecting VMs for ProtectionGroup '{}'.", (Object)ieVmPg.getName());
        Object[] specs = this.convertVmProtectionSpec(ieVmPg.getProtectionProperties());
        if (ArrayUtils.isEmpty((Object[])specs)) {
            LOGGER.info("No protection properties found for VMPG '{}'.", (Object)ieVmPg.getName());
            return Promises.resolve(null);
        }
        SrmService srmService = IContextUtil.getSrmService(ieVmPg.isProtectedSiteLocal());
        VmProtectionGroup vmPg = (VmProtectionGroup)srmService.createStub(protectionGroup);
        FuturePromise vmTasksPromise = new FuturePromise();
        vmPg.protectVms((VmProtectionGroup.VmProtectionSpec[])specs, (Future)vmTasksPromise);
        return vmTasksPromise.thenCompose(vmTasks -> TaskUtil.waitTasks(srmService, (ManagedObjectReference[])Arrays.stream(vmTasks).map(VmProtectionGroup.VmTask::getTask).toArray(ManagedObjectReference[]::new)).onSuccess(unused -> LOGGER.info("Successfully protected all VMs for protection group '{}'.", (Object)ieVmPg.getName())).onError(error -> {
            String message = ImpexL10N.localize("group.protectVms", ieVmPg.getName());
            LOGGER.warn(message, (Throwable)error);
            ImpexImportSrmContext.get().addError(message, (Exception)error);
        }).thenApply(unused -> null));
    }

    private VmProtectionGroup.VmProtectionSpec[] convertVmProtectionSpec(List<IeVmProtectionGroupProperties> properties) {
        if (properties == null) {
            return null;
        }
        return (VmProtectionGroup.VmProtectionSpec[])properties.stream().filter(IeVmProtectionGroupProperties::isVmProtected).map(this::createVmProtectionSpec).toArray(VmProtectionGroup.VmProtectionSpec[]::new);
    }

    private VmProtectionGroup.VmProtectionSpec createVmProtectionSpec(IeVmProtectionGroupProperties properties) {
        VmProtectionGroup.VmProtectionSpec spec = this.createBasicSpec();
        spec.vm = (ManagedObjectReference)this._inventory.get(properties.getId());
        spec.recoverySpec.placeholderVmLocation = this.getPlaceholderVmLocation(properties);
        this._rlsConverter.setRecoveryLocationSettings(spec.getRecoverySpec().getRecoveryLocationSettings(), properties);
        return spec;
    }

    private VmProtectionGroup.VmProtectionSpec createBasicSpec() {
        VmProtectionGroup.VmProtectionSpec spec = new VmProtectionGroup.VmProtectionSpec();
        spec.protectionSettings = new ProtectedVm.ProtectionSettings();
        spec.protectionSettings.changeVersion = "";
        spec.recoverySpec = new VmProtectionGroup.VmRecoverySpec();
        spec.recoverySpec.recoveryLocationSettings = new ProtectedVm.RecoveryLocationSettings();
        spec.recoverySpec.recoveryLocationSettings.changeVersion = "";
        return spec;
    }

    private VmProtectionGroup.PlaceholderVmLocation getPlaceholderVmLocation(IeVmProtectionGroupProperties properties) {
        VmProtectionGroup.PlaceholderVmLocation location = new VmProtectionGroup.PlaceholderVmLocation();
        if (properties == null) {
            return location;
        }
        location.folder = Objects.nonNull(properties.getFolder()) ? (ManagedObjectReference)this._inventory.get(properties.getFolder()) : null;
        location.hostSystem = Objects.nonNull(properties.getHost()) ? (ManagedObjectReference)this._inventory.get(properties.getHost()) : null;
        location.resourcePool = Objects.nonNull(properties.getResourceGroup()) ? (ManagedObjectReference)this._inventory.get(properties.getResourceGroup()) : null;
        return location;
    }
}

