/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.impex.importers.placeholderDatastores;

import com.vmware.srm.client.impex.configurables.placeholderDatastores.IePlaceholderDatastores;
import com.vmware.srm.client.impex.importers.inventory.InventoryExtractor;
import com.vmware.srm.client.impex.tool.ImpexImportSrmContext;
import com.vmware.srm.client.impex.utils.IContextUtil;
import com.vmware.srm.client.impex.utils.ImpexL10N;
import com.vmware.srm.client.impex.utils.TaskUtil;
import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.reactive.impl.FuturePromise;
import com.vmware.srm.client.reactive.impl.Promises;
import com.vmware.srm.client.topology.client.vmomi.availability.srm.SrmService;
import com.vmware.vim.binding.dr.PlaceholderDatastoreManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaceholderDatastoresImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaceholderDatastoresImporter.class);
    private final InventoryExtractor.InventoryLookup _inventory;

    public PlaceholderDatastoresImporter(InventoryExtractor.InventoryLookup inventory) {
        this._inventory = inventory;
    }

    public Promise<Void> create(boolean local) {
        Object[] datastores = this.getDatastoresMoRefs(this.getPlaceholders(local));
        ManagedObjectReference managerMoRef = IContextUtil.getSrmContent((boolean)local).placeholderDatastoreManager;
        String guid = managerMoRef.getServerGuid();
        if (ArrayUtils.isEmpty((Object[])datastores)) {
            LOGGER.info("No placeholder datastores to import for server with guid '{}'.", (Object)guid);
            return Promises.resolve(null);
        }
        SrmService service = IContextUtil.getSrmService(local);
        PlaceholderDatastoreManager manager = (PlaceholderDatastoreManager)service.createStub(managerMoRef);
        FuturePromise taskMoRefFP = new FuturePromise();
        manager.addDatastore((ManagedObjectReference[])datastores, (Future)taskMoRefFP);
        return taskMoRefFP.thenCompose(taskMoRef -> TaskUtil.monitorTask(service, taskMoRef)).onSuccess(unused -> LOGGER.info("Successfully imported placeholder datastores for server with guid '{}'.", (Object)guid)).onError(error -> {
            LOGGER.warn("Failed to import placeholder datastores for server with guid '{}'.", (Object)guid, error);
            ImpexImportSrmContext.get().addError(ImpexL10N.localize("placeholders", new Object[0]), (Exception)error);
        }).thenApply(unused -> null);
    }

    private List<String> getPlaceholders(boolean local) {
        return ImpexImportSrmContext.get().getConfigurablesWrapper().getPlaceholders().stream().filter(iePlaceholders -> iePlaceholders.isLocal() == local).findFirst().map(IePlaceholderDatastores::getDatastores).orElse(Collections.emptyList());
    }

    private ManagedObjectReference[] getDatastoresMoRefs(List<String> datastoreIds) {
        return (ManagedObjectReference[])datastoreIds.stream().filter(id -> {
            boolean present = this._inventory.containsKey(id);
            if (!present) {
                String message = ImpexL10N.localize("placeholders.create", ImpexImportSrmContext.get().names().getDatastore((String)id));
                LOGGER.warn(message);
                ImpexImportSrmContext.get().addError(message);
            }
            return present;
        }).map(this._inventory::get).toArray(ManagedObjectReference[]::new);
    }
}

